/*
 * Decompiled with CFR 0.152.
 */
package net.byteseek.matcher.multisequence;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.byteseek.io.reader.WindowReader;
import net.byteseek.matcher.multisequence.MultiSequenceMatcher;
import net.byteseek.matcher.sequence.SequenceMatcher;
import net.byteseek.utils.ArgUtils;

public class HashMultiSequenceMatcher
implements MultiSequenceMatcher {
    private final List<SequenceMatcher> matchers;
    private final List<SequenceMatcher>[] hashTable;
    private final int minimumLength;
    private final int maximumLength;

    private HashMultiSequenceMatcher(Collection<? extends SequenceMatcher> matchers) {
        ArgUtils.checkNullOrEmptyCollection(matchers, "matchers");
        this.matchers = new ArrayList<SequenceMatcher>(matchers.size());
        this.hashTable = this.createHashTableFor(this.matchers);
        int currentMin = Integer.MAX_VALUE;
        int currentMax = Integer.MIN_VALUE;
        for (SequenceMatcher sequenceMatcher : matchers) {
            int length = sequenceMatcher.length();
            if (length < currentMin) {
                currentMin = length;
            }
            if (length > currentMax) {
                currentMax = length;
            }
            this.addHashFor(sequenceMatcher);
        }
        this.minimumLength = currentMin;
        this.maximumLength = currentMax;
    }

    @Override
    public Collection<SequenceMatcher> allMatches(WindowReader reader, long matchPosition) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Collection<SequenceMatcher> allMatches(byte[] bytes, int matchPosition) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Collection<SequenceMatcher> allMatchesBackwards(WindowReader reader, long matchPosition) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Collection<SequenceMatcher> allMatchesBackwards(byte[] bytes, int matchPosition) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public SequenceMatcher firstMatch(WindowReader reader, long matchPosition) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public SequenceMatcher firstMatch(byte[] bytes, int matchPosition) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public SequenceMatcher firstMatchBackwards(WindowReader reader, long matchPosition) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public SequenceMatcher firstMatchBackwards(byte[] bytes, int matchPosition) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean matchesBackwards(WindowReader reader, long matchPosition) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean matchesBackwards(byte[] bytes, int matchPosition) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int getMinimumLength() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int getMaximumLength() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public MultiSequenceMatcher reverse() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public MultiSequenceMatcher newInstance(Collection<? extends SequenceMatcher> sequences) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public List<SequenceMatcher> getSequenceMatchers() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean matches(WindowReader reader, long matchPosition) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean matches(byte[] bytes, int matchPosition) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private void addHashFor(SequenceMatcher matcher) {
        byte[] matchingBytes;
        for (byte by : matchingBytes = matcher.getMatcherForPosition(0).getMatchingBytes()) {
        }
    }

    private List<SequenceMatcher>[] createHashTableFor(List<SequenceMatcher> matchers) {
        int tableSize = 32;
        return new List[tableSize];
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[num sequences:" + this.matchers.size() + ']';
    }
}

