/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.TimeZone;
import org.icepdf.core.pobjects.security.SecurityManager;

public class PDate {
    protected static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("'D:'yyyyMMddHHmmss");
    private static final int OFFSET_YYYY = 4;
    private static final int OFFSET_MM = 2;
    private static final int OFFSET_DD = 2;
    private static final int OFFSET_HH = 2;
    private static final int OFFSET_mm = 2;
    private static final int OFFSET_SS = 2;
    private static final int OFFSET_0 = 1;
    private static final String DATE_PREFIX = "D:";
    private static String[] monthNames;
    private String year = "";
    private String month = "";
    private String day = "";
    private String hour = "";
    private String minute = "";
    private String second = "";
    private String timeZoneOffset = "";
    private String timeZoneHour = "";
    private String timeZoneMinute = "";
    private boolean notStandardFormat = false;

    public PDate(SecurityManager securityManager, String date) {
        if (date != null) {
            this.parseDate(date);
        }
    }

    public String getYear() {
        return this.year;
    }

    public String getMonth() {
        return this.month;
    }

    public String getDay() {
        return this.day;
    }

    public String getHour() {
        return this.hour;
    }

    public String getMinute() {
        return this.minute;
    }

    public String getSecond() {
        return this.second;
    }

    public String getTimeZoneHour() {
        return this.timeZoneHour;
    }

    public String getTimeZoneMinute() {
        return this.timeZoneMinute;
    }

    public boolean getTimeZoneOffset() {
        return !"-".equals(this.timeZoneOffset);
    }

    public String toString() {
        if (!this.notStandardFormat) {
            StringBuilder sb = new StringBuilder(40);
            if (this.getMonth(this.month).length() > 0) {
                sb.append(this.getMonth(this.month));
            }
            if (this.day.length() > 0) {
                sb.append(" ").append(this.day);
            }
            if (this.year.length() > 0) {
                sb.append(", ").append(this.year);
            }
            if (this.hour.length() > 0) {
                sb.append(" ").append(this.hour);
            }
            if (this.minute.length() > 0) {
                sb.append(":").append(this.minute);
            }
            if (this.second.length() > 0) {
                sb.append(":").append(this.second);
            }
            if (this.timeZoneOffset.length() > 0) {
                if (this.timeZoneOffset.equalsIgnoreCase("Z")) {
                    sb.append(" (UTC)");
                } else {
                    sb.append(" (UTC ").append(this.timeZoneOffset);
                    if (this.timeZoneHour.length() > 0) {
                        sb.append("").append(this.timeZoneHour);
                    }
                    if (this.timeZoneMinute.length() > 0) {
                        sb.append(":").append(this.timeZoneMinute);
                    }
                    sb.append(")");
                }
            }
            return sb.toString();
        }
        return this.day;
    }

    private void parseDate(String date) {
        if (date.indexOf(DATE_PREFIX) >= 0) {
            date = date.substring(2);
            this.parseAdobeDate(date);
        } else if (date.indexOf("/") >= 0) {
            this.parseGhostScriptDate(date);
        } else {
            this.year = date;
            this.month = date;
            this.day = date;
            this.hour = date;
            this.minute = date;
            this.second = date;
            this.timeZoneOffset = date;
            this.timeZoneHour = date;
            this.timeZoneMinute = date;
            this.notStandardFormat = true;
        }
    }

    private void parseGhostScriptDate(String date) {
        StringTokenizer dateTime = new StringTokenizer(date);
        StringTokenizer dateToken = new StringTokenizer(dateTime.nextToken(), "/");
        StringTokenizer timeToken = new StringTokenizer(dateTime.nextToken(), ":");
        this.month = dateToken.nextToken();
        this.day = dateToken.nextToken();
        this.year = dateToken.nextToken();
        this.hour = timeToken.nextToken();
        this.minute = timeToken.nextToken();
        this.second = timeToken.nextToken();
    }

    private void parseAdobeDate(String date) {
        int totalOffset = 0;
        int currentOffset = 0;
        if (totalOffset + 4 <= date.length()) {
            currentOffset = totalOffset + 4;
            this.year = date.substring(totalOffset, currentOffset);
            totalOffset += currentOffset;
        }
        if (totalOffset + 2 <= date.length()) {
            currentOffset = totalOffset + 2;
            this.month = date.substring(totalOffset, currentOffset);
            totalOffset += 2;
        }
        if (totalOffset + 2 <= date.length()) {
            currentOffset = totalOffset + 2;
            this.day = date.substring(totalOffset, currentOffset);
            totalOffset += 2;
        }
        if (totalOffset + 2 <= date.length()) {
            currentOffset = totalOffset + 2;
            this.hour = date.substring(totalOffset, currentOffset);
            totalOffset += 2;
        }
        if (totalOffset + 2 <= date.length()) {
            currentOffset = totalOffset + 2;
            this.minute = date.substring(totalOffset, currentOffset);
            totalOffset += 2;
        }
        if (totalOffset + 2 <= date.length()) {
            currentOffset = totalOffset + 2;
            this.second = date.substring(totalOffset, currentOffset);
            totalOffset += 2;
        }
        if (totalOffset + 1 <= date.length()) {
            currentOffset = totalOffset + 1;
            this.timeZoneOffset = date.substring(totalOffset, currentOffset);
            ++totalOffset;
        }
        if (totalOffset + 2 <= date.length()) {
            currentOffset = totalOffset + 2;
            this.timeZoneHour = date.substring(totalOffset, currentOffset);
            totalOffset += 2;
        }
        if (totalOffset + 4 <= date.length()) {
            this.timeZoneMinute = date.substring(totalOffset + 1, totalOffset + 3);
        }
    }

    private String getMonth(String month) {
        int monthIndex = 0;
        try {
            monthIndex = Integer.parseInt(month);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return monthNames[monthIndex];
    }

    public static String formatDateTime(Date time, TimeZone tz) {
        Calendar cal = Calendar.getInstance(tz, Locale.ENGLISH);
        cal.setTime(time);
        int offset = cal.get(15);
        Date dt1 = new Date(time.getTime() + (long)(offset += cal.get(16)));
        StringBuffer sb = new StringBuffer();
        sb.append(DATE_FORMAT.format(dt1));
        if ((offset /= 60000) == 0) {
            sb.append('Z');
        } else {
            if (offset > 0) {
                sb.append('+');
            } else {
                sb.append('-');
            }
            int offsetHour = Math.abs(offset / 60);
            int offsetMinutes = Math.abs(offset % 60);
            if (offsetHour < 10) {
                sb.append('0');
            }
            sb.append(Integer.toString(offsetHour));
            sb.append('\'');
            if (offsetMinutes < 10) {
                sb.append('0');
            }
            sb.append(Integer.toString(offsetMinutes));
            sb.append('\'');
        }
        return sb.toString();
    }

    public static String formatDateTime(Date time) {
        return PDate.formatDateTime(time, TimeZone.getDefault());
    }

    public static PDate createDate(Date date) {
        return new PDate(null, PDate.formatDateTime(date));
    }

    static {
        DATE_FORMAT.setTimeZone(TimeZone.getTimeZone("GMT"));
        monthNames = new String[]{"", "January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};
    }
}

