/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.graphics.RasterOps;

import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.Raster;
import java.awt.image.RasterOp;
import java.awt.image.WritableRaster;

public class YCbCrRasterOp
implements RasterOp {
    private RenderingHints hints = null;

    public YCbCrRasterOp(RenderingHints hints) {
        this.hints = hints;
    }

    public WritableRaster filter(Raster src, WritableRaster dest) {
        if (dest == null) {
            dest = src.createCompatibleWritableRaster();
        }
        byte[] srcPixels = ((DataBufferByte)src.getDataBuffer()).getData();
        int[] destPixels = ((DataBufferInt)dest.getDataBuffer()).getData();
        int lastY = -1;
        int lastCb = -1;
        int lastCr = -1;
        int rVal = 0;
        int gVal = 0;
        int bVal = 0;
        int bands = src.getNumBands();
        int pixel = 0;
        int intPixels = 0;
        while (pixel < srcPixels.length) {
            int Y = srcPixels[pixel] & 0xFF;
            int Cb = srcPixels[pixel + 1] & 0xFF;
            int Cr = srcPixels[pixel + 2] & 0xFF;
            if (lastY != Y || lastCb != Cb || lastCr != Cr) {
                rVal = YCbCrRasterOp.clamp((int)((double)Y + 1.402 * (double)Cr - 179.456));
                gVal = YCbCrRasterOp.clamp((int)((double)Y - 0.34414 * (double)Cb - 0.71414 * (double)Cr + 135.45984));
                bVal = YCbCrRasterOp.clamp((int)((double)Y + 1.772 * (double)Cb - 226.816));
            }
            lastY = Y;
            lastCb = Cb;
            lastCr = Cr;
            destPixels[intPixels] = (rVal & 0xFF) << 16 | (gVal & 0xFF) << 8 | bVal & 0xFF;
            pixel += bands;
            ++intPixels;
        }
        return dest;
    }

    private static int clamp(int x) {
        return x < 0 ? 0 : (x > 255 ? 255 : x);
    }

    public Rectangle2D getBounds2D(Raster src) {
        return null;
    }

    public WritableRaster createCompatibleDestRaster(Raster src) {
        return src.createCompatibleWritableRaster();
    }

    public Point2D getPoint2D(Point2D srcPt, Point2D dstPt) {
        if (dstPt == null) {
            dstPt = (Point2D)srcPt.clone();
        } else {
            dstPt.setLocation(srcPt);
        }
        return dstPt;
    }

    public RenderingHints getRenderingHints() {
        return this.hints;
    }
}

