/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.jpeg2000;

import edu.harvard.hul.ois.jhove.module.jpeg2000.BoxHeader;
import edu.harvard.hul.ois.jhove.module.jpeg2000.BoxHolder;
import edu.harvard.hul.ois.jhove.module.jpeg2000.CaptureResolutionBox;
import edu.harvard.hul.ois.jhove.module.jpeg2000.DDResolutionBox;
import edu.harvard.hul.ois.jhove.module.jpeg2000.JP2Box;
import java.io.IOException;
import java.io.RandomAccessFile;

public class ResolutionBox
extends JP2Box {
    public ResolutionBox(RandomAccessFile raf, BoxHolder parent) {
        super(raf, parent);
    }

    @Override
    public boolean readBox() throws IOException {
        JP2Box box;
        boolean seenresc = false;
        boolean seenresd = false;
        this.initBytesRead();
        this.hasBoxes = true;
        int sizeLeft = (int)this._boxHeader.getDataLength();
        BoxHeader subhdr = new BoxHeader(this._module, this._dstrm);
        while (this.hasNext() && (box = (JP2Box)this.next()) != null) {
            if (box instanceof CaptureResolutionBox) {
                seenresc = true;
                if (box.readBox()) continue;
                return false;
            }
            if (box instanceof DDResolutionBox) {
                seenresd = true;
                if (box.readBox()) continue;
                return false;
            }
            box.skipBox();
        }
        this.finalizeBytesRead();
        return true;
    }

    @Override
    protected String getSelfPropName() {
        return "Resolution Box";
    }
}

