/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.tiff;

import edu.harvard.hul.ois.jhove.ErrorMessage;
import edu.harvard.hul.ois.jhove.Message;
import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.RepInfo;
import edu.harvard.hul.ois.jhove.module.tiff.IFD;
import edu.harvard.hul.ois.jhove.module.tiff.TiffException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.LinkedList;

public class InteroperabilityIFD
extends IFD {
    private static final int INTEROPERABILITYINDEX = 1;
    private String _interoperabilityIndex;

    public InteroperabilityIFD(long offset, RepInfo info, RandomAccessFile raf, boolean bigEndian) {
        super(offset, info, raf, bigEndian);
    }

    public String getInteroperabilityIndex() {
        return this._interoperabilityIndex;
    }

    @Override
    public Property getProperty(boolean rawOutput) {
        LinkedList<Property> entries = new LinkedList<Property>();
        entries.add(new Property("Index", PropertyType.STRING, (Object)this._interoperabilityIndex));
        return this.propertyHeader("Exif Interoperability", entries);
    }

    @Override
    public void lookupTag(int tag, int type, long count, long value) throws TiffException {
        try {
            if (tag == 1) {
                InteroperabilityIFD.checkType(tag, type, 2);
                this._interoperabilityIndex = this.readASCII(count, value);
            } else {
                this._info.setMessage((Message)new ErrorMessage("Unknown Exif Interoperability IFD tag", "Tag = " + tag, value));
            }
        }
        catch (IOException e) {
            throw new TiffException("Read error for tag " + tag, value);
        }
    }
}

