/*
 * Decompiled with CFR 0.152.
 */
package ch.docuteam.darc.mets.amdsec;

import ch.docuteam.darc.common.NodeAbstract;
import ch.docuteam.darc.mets.Document;
import ch.docuteam.darc.mets.amdsec.DigiprovAbstract;
import ch.docuteam.darc.mets.amdsec.DigiprovWithPremis;
import ch.docuteam.tools.exception.Exception;
import ch.docuteam.tools.id.UniqueID;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;

public class AMDSection
extends NodeAbstract {
    protected Map<String, DigiprovAbstract> digiprovs = new HashMap<String, DigiprovAbstract>();

    protected AMDSection() {
    }

    private AMDSection(Document document) {
        this.document = document;
        if (this.document.selectNodes("./METS:mets/METS:amdSec").size() >= 2) {
            Exception.remember((String)("Bad number of AMD sections in the METS file. Expected: 1, found: " + this.document.selectNodes("./METS:mets/METS:amdSec").size()));
        }
        this.element = (Element)this.document.selectSingleNode("./METS:mets/METS:amdSec");
        if (this.element == null) {
            this.element = DocumentHelper.createElement((QName)DocumentHelper.createQName((String)"amdSec", (Namespace)this.document.getRootElement().getNamespace())).addAttribute("ID", UniqueID.getXML());
            List elements = this.document.getRootElement().elements();
            elements.add(elements.indexOf(this.document.selectSingleNode("//METS:fileSec | //METS:structMap")), this.element);
        }
        this.id = this.element.attributeValue("ID");
        this.addAllDigiprovs(DigiprovWithPremis.parse(this));
    }

    public static AMDSection parse(Document document) {
        return new AMDSection(document);
    }

    public Collection<? extends DigiprovAbstract> getDigiprovs() {
        return this.digiprovs.values();
    }

    public DigiprovWithPremis getDigiprov(String id) {
        return (DigiprovWithPremis)this.digiprovs.get(id);
    }

    public void addAllDigiprovs(List<? extends DigiprovAbstract> digiprovs) {
        for (DigiprovAbstract digiprovAbstract : digiprovs) {
            this.addNewDigiprov(digiprovAbstract);
        }
    }

    public void addNewDigiprov(DigiprovAbstract digiprov) {
        this.digiprovs.put(digiprov.getId(), digiprov);
    }

    public void deleteDigiprov(DigiprovAbstract digiprov) {
        this.digiprovs.remove(digiprov.getId());
    }

    public String toString() {
        StringBuilder buf = new StringBuilder("\n[AMDSection:" + this.id + "(digiprovs:" + this.digiprovs.size() + ")");
        for (DigiprovAbstract digiprov : this.digiprovs.values()) {
            buf.append("\n\t" + digiprov.toString());
        }
        buf.append("\n]");
        return buf.toString();
    }
}

