/*
 * Decompiled with CFR 0.152.
 */
package org.jodconverter.local.process;

import java.io.IOException;
import java.util.regex.Pattern;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jodconverter.local.process.AbstractProcessManager;

public class WindowsProcessManager
extends AbstractProcessManager {
    private static final Pattern PROCESS_GET_LINE = Pattern.compile("^\\s*(?<CommandLine>.*?)\\s+(?<Pid>\\d+)\\s*$");

    public static @NonNull WindowsProcessManager getDefault() {
        return DefaultHolder.INSTANCE;
    }

    @Override
    protected @NonNull String[] getRunningProcessesCommand(@NonNull String process) {
        return new String[]{"cmd", "/c", "wmic process where(name like '" + process + "%') get commandline,processid"};
    }

    @Override
    protected @NonNull Pattern getRunningProcessLinePattern() {
        return PROCESS_GET_LINE;
    }

    public boolean isUsable() {
        try {
            this.execute("wmic", "quit");
            this.execute("taskkill", "/?");
            return true;
        }
        catch (IOException ioEx) {
            return false;
        }
    }

    @Override
    public void kill(@Nullable Process process, long pid) throws IOException {
        if (pid > -1L) {
            this.execute("taskkill", "/t", "/f", "/pid", String.valueOf(pid));
        } else {
            super.kill(process, pid);
        }
    }

    private static class DefaultHolder {
        static final WindowsProcessManager INSTANCE = new WindowsProcessManager();

        private DefaultHolder() {
        }
    }
}

