/*
 * Decompiled with CFR 0.152.
 */
package net.byteseek.searcher.multisequence.wu_manber;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.byteseek.io.reader.WindowReader;
import net.byteseek.io.reader.windows.Window;
import net.byteseek.matcher.bytes.ByteMatcher;
import net.byteseek.matcher.multisequence.MultiSequenceMatcher;
import net.byteseek.matcher.multisequence.MultiSequenceReverseMatcher;
import net.byteseek.matcher.sequence.SequenceMatcher;
import net.byteseek.searcher.SearchResult;
import net.byteseek.searcher.SearchUtils;
import net.byteseek.searcher.Searcher;
import net.byteseek.searcher.multisequence.AbstractMultiSequenceSearcher;
import net.byteseek.utils.ByteUtils;
import net.byteseek.utils.collections.BytePermutationIterator;
import net.byteseek.utils.factory.ObjectFactory;
import net.byteseek.utils.lazy.DoubleCheckImmutableLazyObject;
import net.byteseek.utils.lazy.LazyObject;

public class WuManberOneByteFinalFlagSearcher {
    public static int getBlockSize(MultiSequenceMatcher matcher) {
        return WuManberOneByteFinalFlagSearcher.getBlockSize(matcher, 256);
    }

    public static int getBlockSize(MultiSequenceMatcher matcher, int alphabetSize) {
        int minLength = matcher.getMinimumLength();
        int numberOfSequences = matcher.getSequenceMatchers().size();
        return WuManberOneByteFinalFlagSearcher.getBlockSize(minLength, numberOfSequences, alphabetSize);
    }

    public static int getBlockSize(int minimumLength, int numberOfSequences, int alphabetSize) {
        double optimumBlockSize = WuManberOneByteFinalFlagSearcher.getWuManberRecommendedBlockSize(alphabetSize, minimumLength, numberOfSequences);
        int possibleBlockSize = (int)Math.ceil(optimumBlockSize);
        int notGreaterThanMinimumLength = minimumLength < possibleBlockSize ? minimumLength : possibleBlockSize;
        return notGreaterThanMinimumLength > 1 ? notGreaterThanMinimumLength : 1;
    }

    public static double getWuManberRecommendedBlockSize(int alphabetSize, int minimumLength, int numberOfSequences) {
        return WuManberOneByteFinalFlagSearcher.logOfBase(alphabetSize, 2 * minimumLength * numberOfSequences);
    }

    private static double logOfBase(int base, int number) {
        return Math.log(number) / Math.log(base);
    }

    private static Searcher<SequenceMatcher> createSearchInstance(MultiSequenceMatcher matcher, int blockSize) {
        return new OneByteBlockSearcher(matcher);
    }

    public WuManberOneByteFinalFlagSearcher(MultiSequenceMatcher matcher) {
        this(matcher, WuManberOneByteFinalFlagSearcher.getBlockSize(matcher));
    }

    public WuManberOneByteFinalFlagSearcher(MultiSequenceMatcher matcher, int blockSize) {
    }

    public static final class OneByteBlockSearcher
    extends AbstractWuManberSearcher {
        public OneByteBlockSearcher(MultiSequenceMatcher matcher) {
            super(matcher, 1);
        }

        @Override
        public List<SearchResult<SequenceMatcher>> searchForwards(byte[] bytes, int fromPosition, int toPosition) {
            int searchPosition;
            SearchInfo info = (SearchInfo)this.forwardInfo.get();
            int[] safeShifts = info.shifts;
            MultiSequenceMatcher backMatcher = info.matcher;
            int lastPossiblePosition = bytes.length - 1;
            int lastToPosition = toPosition + this.sequences.getMaximumLength() - 1;
            int lastPosition = lastToPosition < lastPossiblePosition ? lastToPosition : lastPossiblePosition;
            int minimumPosition = this.sequences.getMinimumLength() - 1;
            int n = searchPosition = fromPosition > 0 ? fromPosition + minimumPosition : minimumPosition;
            while (searchPosition <= lastPosition) {
                int safeShift = safeShifts[bytes[searchPosition] & 0xFF];
                if (safeShift < 0) {
                    List<SearchResult<SequenceMatcher>> results;
                    Collection<SequenceMatcher> matches = backMatcher.allMatchesBackwards(bytes, searchPosition);
                    if (!matches.isEmpty() && !(results = SearchUtils.resultsBackFromPosition(searchPosition, matches, fromPosition, toPosition)).isEmpty()) {
                        return results;
                    }
                    searchPosition -= safeShift;
                    continue;
                }
                searchPosition += safeShift;
            }
            return SearchUtils.noResults();
        }

        @Override
        protected List<SearchResult<SequenceMatcher>> doSearchForwards(WindowReader reader, long fromPosition, long toPosition) throws IOException {
            Window window;
            int arrayStartPosition;
            int arraySearchPosition;
            SearchInfo info = (SearchInfo)this.forwardInfo.get();
            int[] safeShifts = info.shifts;
            MultiSequenceMatcher backMatcher = info.matcher;
            long finalPosition = toPosition + (long)this.sequences.getMaximumLength() - 1L;
            for (long searchPosition = fromPosition + (long)this.sequences.getMinimumLength() - 1L; searchPosition <= finalPosition && (window = reader.getWindow(searchPosition)) != null; searchPosition += (long)(arraySearchPosition - arrayStartPosition)) {
                byte[] array = window.getArray();
                arrayStartPosition = reader.getWindowOffset(searchPosition);
                int arrayEndPosition = window.length() - 1;
                long distanceToEnd = finalPosition - window.getWindowPosition();
                int lastSearchPosition = distanceToEnd < (long)arrayEndPosition ? (int)distanceToEnd : arrayEndPosition;
                arraySearchPosition = arrayStartPosition;
                long DEBUG_SEARCH = searchPosition;
                while (arraySearchPosition <= lastSearchPosition) {
                    int safeShift = safeShifts[array[arraySearchPosition] & 0xFF];
                    if (safeShift < 0) {
                        List<SearchResult<SequenceMatcher>> results;
                        long matchEndPosition = searchPosition + (long)arraySearchPosition - (long)arrayStartPosition;
                        Collection<SequenceMatcher> matches = backMatcher.allMatchesBackwards(reader, matchEndPosition);
                        if (!matches.isEmpty() && !(results = SearchUtils.resultsBackFromPosition(matchEndPosition, matches, fromPosition, toPosition)).isEmpty()) {
                            return results;
                        }
                        arraySearchPosition -= safeShift;
                        DEBUG_SEARCH -= (long)safeShift;
                        continue;
                    }
                    arraySearchPosition += safeShift;
                    DEBUG_SEARCH += (long)safeShift;
                }
            }
            return SearchUtils.noResults();
        }

        @Override
        protected List<SearchResult<SequenceMatcher>> doSearchBackwards(WindowReader reader, long fromPosition, long toPosition) throws IOException {
            Window window;
            int arraySearchPosition;
            int arrayStartPosition;
            SearchInfo info = (SearchInfo)this.backwardInfo.get();
            int[] safeShifts = info.shifts;
            MultiSequenceMatcher verifier = info.matcher;
            for (long searchPosition = fromPosition; searchPosition >= toPosition && (window = reader.getWindow(searchPosition)) != null; searchPosition -= (long)(arrayStartPosition - arraySearchPosition)) {
                byte[] array = window.getArray();
                arrayStartPosition = reader.getWindowOffset(searchPosition);
                long distanceToEnd = toPosition - window.getWindowPosition();
                int lastSearchPosition = distanceToEnd > 0L ? (int)distanceToEnd : 0;
                arraySearchPosition = arrayStartPosition;
                while (arraySearchPosition >= lastSearchPosition) {
                    int safeShift = safeShifts[array[arraySearchPosition] & 0xFF];
                    if (safeShift < 0) {
                        long startMatchPosition = searchPosition + (long)arraySearchPosition - (long)arrayStartPosition;
                        Collection<SequenceMatcher> matches = verifier.allMatches(reader, startMatchPosition);
                        if (!matches.isEmpty()) {
                            return SearchUtils.resultsAtPosition(startMatchPosition, matches);
                        }
                        arraySearchPosition += safeShift;
                        continue;
                    }
                    arraySearchPosition -= safeShift;
                }
            }
            return SearchUtils.noResults();
        }

        @Override
        public List<SearchResult<SequenceMatcher>> searchBackwards(byte[] bytes, int fromPosition, int toPosition) {
            int searchPosition;
            SearchInfo info = (SearchInfo)this.backwardInfo.get();
            int[] safeShifts = info.shifts;
            MultiSequenceMatcher verifier = info.matcher;
            int lastPosition = toPosition > 0 ? toPosition : 0;
            int firstPossiblePosition = bytes.length - 1;
            int n = searchPosition = fromPosition < firstPossiblePosition ? fromPosition : firstPossiblePosition;
            while (searchPosition >= lastPosition) {
                int safeShift = safeShifts[bytes[searchPosition] & 0xFF];
                if (safeShift < 0) {
                    Collection<SequenceMatcher> matches = verifier.allMatches(bytes, searchPosition);
                    if (!matches.isEmpty()) {
                        return SearchUtils.resultsAtPosition(searchPosition, matches);
                    }
                    searchPosition += safeShift;
                    continue;
                }
                searchPosition -= safeShift;
            }
            return SearchUtils.noResults();
        }
    }

    public static abstract class AbstractWuManberSearcher
    extends AbstractMultiSequenceSearcher {
        private static int HIGHEST_POWER_OF_TWO = 0x40000000;
        protected final int blockSize;
        protected final LazyObject<SearchInfo> forwardInfo;
        protected final LazyObject<SearchInfo> backwardInfo;

        public AbstractWuManberSearcher(MultiSequenceMatcher matcher, int blockSize) {
            super(matcher);
            this.blockSize = blockSize;
            this.forwardInfo = new DoubleCheckImmutableLazyObject<SearchInfo>(new ForwardInfoFactory());
            this.backwardInfo = new DoubleCheckImmutableLazyObject<SearchInfo>(new BackwardSearchInfo());
        }

        @Override
        public void prepareForwards() {
            this.forwardInfo.get();
        }

        @Override
        public void prepareBackwards() {
            this.backwardInfo.get();
        }

        @Override
        public String toString() {
            return this.getClass().getSimpleName() + "[block size: " + this.blockSize + " sequences:" + this.sequences + ']';
        }

        private List<byte[]> getBlockByteList(int position, SequenceMatcher matcher) {
            ArrayList<byte[]> byteList = new ArrayList<byte[]>(this.blockSize);
            for (int blockIndex = position - this.blockSize + 1; blockIndex <= position; ++blockIndex) {
                ByteMatcher byteMatcher = matcher.getMatcherForPosition(blockIndex);
                byteList.add(byteMatcher.getMatchingBytes());
            }
            return byteList;
        }

        private static int getBlockHash(byte[] block) {
            int hashCode = 0;
            for (byte b : block) {
                hashCode = (hashCode << 5) - hashCode + (b & 0xFF);
            }
            return hashCode;
        }

        private int[] createShiftHashTable(int defaultShift) {
            int possibleTableSize = this.guessTableSize();
            int optimumTableSize = this.chooseOptimumSize(possibleTableSize);
            int[] shifts = new int[optimumTableSize];
            Arrays.fill(shifts, defaultShift);
            return shifts;
        }

        private int guessTableSize() {
            return 128 + this.sequences.getSequenceMatchers().size() * 16;
        }

        private int chooseOptimumSize(int suggestedSize) {
            int positiveSize = suggestedSize > 1 ? suggestedSize : 1;
            int possibleSize = ByteUtils.isPowerOfTwo(positiveSize) ? positiveSize : ByteUtils.nextHighestPowerOfTwo(positiveSize);
            int maxSize = this.getMaxTableSize();
            return possibleSize < maxSize ? possibleSize : maxSize;
        }

        private int getMaxTableSize() {
            switch (this.blockSize) {
                case 1: {
                    return 256;
                }
                case 2: {
                    return 65536;
                }
                case 3: {
                    return 0x1000000;
                }
            }
            return HIGHEST_POWER_OF_TWO;
        }

        protected class BackwardSearchInfo
        implements ObjectFactory<SearchInfo> {
            protected BackwardSearchInfo() {
            }

            @Override
            public SearchInfo create() {
                return new SearchInfo(this.getShifts(), this.getMatcher());
            }

            private int[] getShifts() {
                int minLength = AbstractWuManberSearcher.this.sequences.getMinimumLength();
                int defaultShift = minLength - AbstractWuManberSearcher.this.blockSize + 1;
                int[] shifts = AbstractWuManberSearcher.this.createShiftHashTable(defaultShift);
                int hashBitMask = shifts.length - 1;
                for (SequenceMatcher sequence : AbstractWuManberSearcher.this.sequences.getSequenceMatchers()) {
                    for (int blockEndPosition = AbstractWuManberSearcher.this.blockSize; blockEndPosition < minLength; ++blockEndPosition) {
                        int distanceToStart = blockEndPosition - AbstractWuManberSearcher.this.blockSize + 1;
                        List blockBytes = AbstractWuManberSearcher.this.getBlockByteList(blockEndPosition, sequence);
                        BytePermutationIterator permutation = new BytePermutationIterator(blockBytes);
                        while (permutation.hasNext()) {
                            int hashPos = AbstractWuManberSearcher.getBlockHash(permutation.next()) & hashBitMask;
                            int currentShift = shifts[hashPos];
                            if (distanceToStart >= currentShift) continue;
                            shifts[hashPos] = distanceToStart;
                        }
                    }
                }
                for (SequenceMatcher sequence : AbstractWuManberSearcher.this.sequences.getSequenceMatchers()) {
                    List blockBytes = AbstractWuManberSearcher.this.getBlockByteList(0, sequence);
                    BytePermutationIterator permutation = new BytePermutationIterator(blockBytes);
                    while (permutation.hasNext()) {
                        int hashPos = AbstractWuManberSearcher.getBlockHash(permutation.next()) & hashBitMask;
                        int currentShift = shifts[hashPos];
                        if (currentShift <= 0) continue;
                        shifts[hashPos] = -currentShift;
                    }
                }
                return shifts;
            }

            private MultiSequenceMatcher getMatcher() {
                return AbstractWuManberSearcher.this.sequences;
            }
        }

        protected class ForwardInfoFactory
        implements ObjectFactory<SearchInfo> {
            protected ForwardInfoFactory() {
            }

            @Override
            public SearchInfo create() {
                return new SearchInfo(this.getShifts(), this.getMatcher());
            }

            private int[] getShifts() {
                int defaultShift = AbstractWuManberSearcher.this.sequences.getMinimumLength() - AbstractWuManberSearcher.this.blockSize + 1;
                int[] shifts = AbstractWuManberSearcher.this.createShiftHashTable(defaultShift);
                int hashBitMask = shifts.length - 1;
                for (SequenceMatcher sequence : AbstractWuManberSearcher.this.sequences.getSequenceMatchers()) {
                    int firstBlockEndPosition;
                    int matcherLength = sequence.length();
                    for (int blockEndPosition = firstBlockEndPosition = matcherLength - AbstractWuManberSearcher.this.sequences.getMinimumLength() + AbstractWuManberSearcher.this.blockSize - 1; blockEndPosition < matcherLength - 1; ++blockEndPosition) {
                        int distanceFromEnd = matcherLength - blockEndPosition - 1;
                        List blockBytes = AbstractWuManberSearcher.this.getBlockByteList(blockEndPosition, sequence);
                        BytePermutationIterator permutation = new BytePermutationIterator(blockBytes);
                        while (permutation.hasNext()) {
                            int hashPos = AbstractWuManberSearcher.getBlockHash(permutation.next()) & hashBitMask;
                            int currentShift = shifts[hashPos];
                            if (distanceFromEnd >= currentShift) continue;
                            shifts[hashPos] = distanceFromEnd;
                        }
                    }
                }
                for (SequenceMatcher sequence : AbstractWuManberSearcher.this.sequences.getSequenceMatchers()) {
                    List blockBytes = AbstractWuManberSearcher.this.getBlockByteList(sequence.length() - 1, sequence);
                    BytePermutationIterator permutation = new BytePermutationIterator(blockBytes);
                    while (permutation.hasNext()) {
                        int hashPos = AbstractWuManberSearcher.getBlockHash(permutation.next()) & hashBitMask;
                        int currentShift = shifts[hashPos];
                        if (currentShift <= 0) continue;
                        shifts[hashPos] = -currentShift;
                    }
                }
                return shifts;
            }

            private MultiSequenceMatcher getMatcher() {
                return new MultiSequenceReverseMatcher(AbstractWuManberSearcher.this.sequences);
            }
        }
    }

    private static final class SearchInfo {
        private int[] shifts;
        private MultiSequenceMatcher matcher;

        private SearchInfo(int[] shifts, MultiSequenceMatcher matcher) {
            this.shifts = shifts;
            this.matcher = matcher;
        }
    }
}

