/*
 * Decompiled with CFR 0.152.
 */
package org.jwat.common;

import java.io.ByteArrayOutputStream;
import java.util.Arrays;

public class Base64 {
    private static String encodeTab = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
    public static byte[] decodeTab = new byte[256];

    protected Base64() {
    }

    public static String decodeToString(String in, boolean bStrict) {
        if (in == null) {
            return null;
        }
        if (in.length() == 0) {
            return "";
        }
        StringBuffer out = new StringBuffer(256);
        boolean b = true;
        int idx = 0;
        int mod = 0;
        int cout = 0;
        while (b) {
            if (idx < in.length()) {
                char cin = in.charAt(idx);
                if (cin == '=') {
                    b = false;
                    continue;
                }
                ++idx;
                byte cIdx = decodeTab[cin];
                if (cIdx != -1) {
                    switch (mod) {
                        case 0: {
                            cout = cIdx << 2;
                            break;
                        }
                        case 1: {
                            out.append((char)(cout |= cIdx >> 4));
                            cout = cIdx << 4 & 0xFF;
                            break;
                        }
                        case 2: {
                            out.append((char)(cout |= cIdx >> 2));
                            cout = cIdx << 6 & 0xFF;
                            break;
                        }
                        case 3: {
                            out.append((char)(cout |= cIdx));
                        }
                    }
                    mod = (mod + 1) % 4;
                    continue;
                }
                return null;
            }
            b = false;
        }
        if (mod == 1) {
            return null;
        }
        if (bStrict) {
            while (mod != 0 && idx < in.length() && in.charAt(idx) == '=') {
                ++idx;
                mod = (mod + 1) % 4;
            }
            if (mod != 0 || idx < in.length()) {
                return null;
            }
        }
        return out.toString();
    }

    public static byte[] decodeToArray(String in, boolean bStrict) {
        if (in == null) {
            return null;
        }
        if (in.length() == 0) {
            return new byte[0];
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        boolean b = true;
        int idx = 0;
        int mod = 0;
        int cout = 0;
        while (b) {
            if (idx < in.length()) {
                char cin = in.charAt(idx);
                if (cin == '=') {
                    b = false;
                    continue;
                }
                ++idx;
                byte cIdx = decodeTab[cin];
                if (cIdx != -1) {
                    switch (mod) {
                        case 0: {
                            cout = cIdx << 2;
                            break;
                        }
                        case 1: {
                            out.write(cout |= cIdx >> 4);
                            cout = cIdx << 4 & 0xFF;
                            break;
                        }
                        case 2: {
                            out.write(cout |= cIdx >> 2);
                            cout = cIdx << 6 & 0xFF;
                            break;
                        }
                        case 3: {
                            out.write(cout |= cIdx);
                        }
                    }
                    mod = (mod + 1) % 4;
                    continue;
                }
                return null;
            }
            b = false;
        }
        if (mod == 1) {
            return null;
        }
        if (bStrict) {
            while (mod != 0 && idx < in.length() && in.charAt(idx) == '=') {
                ++idx;
                mod = (mod + 1) % 4;
            }
            if (mod != 0 || idx < in.length()) {
                return null;
            }
        }
        return out.toByteArray();
    }

    public static String encodeString(String in) {
        if (in == null) {
            return null;
        }
        if (in.length() == 0) {
            return "";
        }
        StringBuffer out = new StringBuffer(256);
        boolean b = true;
        int idx = 0;
        int cout = 0;
        int mod = 0;
        while (b) {
            if (idx < in.length()) {
                char cin;
                if ((cin = in.charAt(idx++)) < '\u0100') {
                    switch (mod) {
                        case 0: {
                            cout = cin >> 2 & 0x3F;
                            out.append(encodeTab.charAt(cout));
                            cout = cin << 4 & 0x3F;
                            break;
                        }
                        case 1: {
                            out.append(encodeTab.charAt(cout |= cin >> 4 & 0x3F));
                            cout = cin << 2 & 0x3F;
                            break;
                        }
                        case 2: {
                            out.append(encodeTab.charAt(cout |= cin >> 6 & 0x3F));
                            cout = cin & 0x3F;
                            out.append(encodeTab.charAt(cout));
                        }
                    }
                    mod = (mod + 1) % 3;
                    continue;
                }
                return null;
            }
            b = false;
        }
        switch (mod) {
            case 0: {
                break;
            }
            case 1: {
                out.append(encodeTab.charAt(cout));
                out.append("==");
                break;
            }
            case 2: {
                out.append(encodeTab.charAt(cout));
                out.append("=");
            }
        }
        return out.toString();
    }

    public static String encodeArray(byte[] in) {
        if (in == null) {
            return null;
        }
        if (in.length == 0) {
            return "";
        }
        StringBuffer out = new StringBuffer(256);
        boolean b = true;
        int idx = 0;
        int cout = 0;
        int mod = 0;
        while (b) {
            if (idx < in.length) {
                int cin = in[idx++] & 0xFF;
                switch (mod) {
                    case 0: {
                        cout = cin >> 2 & 0x3F;
                        out.append(encodeTab.charAt(cout));
                        cout = cin << 4 & 0x3F;
                        break;
                    }
                    case 1: {
                        out.append(encodeTab.charAt(cout |= cin >> 4 & 0x3F));
                        cout = cin << 2 & 0x3F;
                        break;
                    }
                    case 2: {
                        out.append(encodeTab.charAt(cout |= cin >> 6 & 0x3F));
                        cout = cin & 0x3F;
                        out.append(encodeTab.charAt(cout));
                    }
                }
                mod = (mod + 1) % 3;
                continue;
            }
            b = false;
        }
        switch (mod) {
            case 0: {
                break;
            }
            case 1: {
                out.append(encodeTab.charAt(cout));
                out.append("==");
                break;
            }
            case 2: {
                out.append(encodeTab.charAt(cout));
                out.append("=");
            }
        }
        return out.toString();
    }

    static {
        Arrays.fill(decodeTab, (byte)-1);
        for (int i = 0; i < encodeTab.length(); ++i) {
            Base64.decodeTab[Base64.encodeTab.charAt((int)i)] = (byte)i;
        }
    }
}

