/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.aiff;

import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyArity;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.RepInfo;
import edu.harvard.hul.ois.jhove.module.AiffModule;
import edu.harvard.hul.ois.jhove.module.iff.Chunk;
import edu.harvard.hul.ois.jhove.module.iff.ChunkHeader;
import java.io.DataInputStream;
import java.io.IOException;

public class SoundDataChunk
extends Chunk {
    public SoundDataChunk(AiffModule module, ChunkHeader hdr, DataInputStream dstrm) {
        super(module, hdr, dstrm);
    }

    @Override
    public boolean readChunk(RepInfo info) throws IOException {
        AiffModule module = (AiffModule)this._module;
        Property[] propArray = new Property[3];
        long offset = module.readUnsignedInt(this._dstream);
        long blockSize = module.readUnsignedInt(this._dstream);
        propArray[0] = new Property("Offset", PropertyType.LONG, (Object)new Long(offset));
        propArray[1] = new Property("BlockSize", PropertyType.LONG, (Object)new Long(blockSize));
        propArray[2] = new Property("DataLength", PropertyType.LONG, (Object)new Long(this.bytesLeft - 8L));
        module.addAiffProperty(new Property("SoundData", PropertyType.PROPERTY, PropertyArity.ARRAY, (Object)propArray));
        module.markFirstSampleOffset(offset);
        module.skipBytes(this._dstream, (int)(this.bytesLeft - 8L), module);
        return true;
    }
}

