/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.html;

import edu.harvard.hul.ois.jhove.module.html.HtmlAttributeDesc;
import edu.harvard.hul.ois.jhove.module.html.HtmlDocDesc;
import edu.harvard.hul.ois.jhove.module.html.HtmlSpecialToken;
import edu.harvard.hul.ois.jhove.module.html.JHOpenTag;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class HtmlTagDesc {
    private String _name;
    private boolean _openTagRequired;
    private boolean _closeTagRequired;
    private List _implicitContainers;
    private List[] _contentArray;
    private String[] _excludedContent;
    protected int[] _sequence;
    public static final int SEQ0_1 = 0;
    public static final int SEQ1 = 1;
    public static final int SEQ1_MANY = 2;
    public static final int SEQ0_MANY = 3;
    private List _attributes;

    public HtmlTagDesc(String name, boolean openTagRequired, boolean closeTagRequired, List content, List attributes) {
        this._name = name.toLowerCase();
        this._openTagRequired = openTagRequired;
        this._closeTagRequired = closeTagRequired;
        this._implicitContainers = new LinkedList();
        if (content == null) {
            this._contentArray = null;
        } else {
            this._contentArray = new List[1];
            this._contentArray[0] = content;
            this._sequence = new int[1];
            this._sequence[0] = 3;
        }
        this._attributes = attributes == null ? new ArrayList(1) : attributes;
    }

    public HtmlTagDesc(String name, boolean openTagRequired, boolean closeTagRequired, int[] sequence, List[] contentArray, List attributes) {
        this._name = name.toLowerCase();
        this._openTagRequired = openTagRequired;
        this._closeTagRequired = closeTagRequired;
        this._implicitContainers = new LinkedList();
        this._sequence = sequence;
        this._contentArray = contentArray;
        this._attributes = attributes == null ? new ArrayList(1) : attributes;
    }

    public void setExcludedContent(String[] content) {
        this._excludedContent = content;
    }

    public boolean excludesTag(String tag) {
        if (this._excludedContent == null) {
            return false;
        }
        for (int i = 0; i < this._excludedContent.length; ++i) {
            if (!this._excludedContent[i].equals(tag)) continue;
            return true;
        }
        return false;
    }

    public void setAttributes(String[] attributeArray) {
        ArrayList<HtmlAttributeDesc> atts = new ArrayList<HtmlAttributeDesc>(attributeArray.length);
        for (int i = 0; i < attributeArray.length; ++i) {
            HtmlAttributeDesc desc = new HtmlAttributeDesc(attributeArray[i]);
            atts.add(desc);
        }
        this._attributes = atts;
    }

    public void addImplicitContainer(HtmlTagDesc container) {
        this._implicitContainers.add(container);
    }

    public boolean matches(String name) {
        return name.equals(this._name);
    }

    public boolean isTemp() {
        return false;
    }

    protected boolean allowsTag(String tag, int index, HtmlDocDesc doc) {
        if (this._contentArray == null) {
            return false;
        }
        if (index >= this._contentArray.length) {
            return false;
        }
        Iterator iter = this._contentArray[index].iterator();
        while (iter.hasNext()) {
            String allowedTag;
            try {
                allowedTag = (String)iter.next();
            }
            catch (Exception e) {
                continue;
            }
            if (!allowedTag.equals(tag)) continue;
            return true;
        }
        HtmlTagDesc tagDesc = (HtmlTagDesc)doc.supportedElements.get(tag);
        if (tagDesc != null && tagDesc._implicitContainers != null) {
            for (HtmlTagDesc ctnr : tagDesc._implicitContainers) {
                if (!this.allowsTag(ctnr._name, index, doc)) continue;
                JHOpenTag ctnrTag = new JHOpenTag(ctnr._name);
                ctnrTag.setElement(ctnr);
                doc.pushElementStack(ctnrTag);
                return true;
            }
        }
        return false;
    }

    protected List implicitContainers(String tag) {
        return this._implicitContainers;
    }

    protected boolean canGetMoreAt(int index, int elemCount) {
        switch (this._sequence[index]) {
            case 0: 
            case 1: {
                return elemCount == 0;
            }
            case 2: 
            case 3: {
                return true;
            }
        }
        return false;
    }

    protected boolean canAdvanceFrom(int index, int elemCount) {
        if (index == this._sequence.length - 1) {
            return false;
        }
        switch (this._sequence[index]) {
            case 0: 
            case 3: {
                return true;
            }
            case 1: {
                return elemCount == 1;
            }
            case 2: {
                return elemCount >= 1;
            }
        }
        return false;
    }

    protected boolean allowsTag(String tag, HtmlDocDesc doc) {
        return this.allowsTag(tag, 0, doc);
    }

    protected boolean allowsPCData() {
        if (this._contentArray == null) {
            return false;
        }
        for (Object contentItem : this._contentArray[0]) {
            if (contentItem != HtmlSpecialToken.PCDATA) continue;
            return true;
        }
        return false;
    }

    protected HtmlAttributeDesc namedAttDesc(String name) {
        for (HtmlAttributeDesc desc : this._attributes) {
            if (!desc.nameMatches(name)) continue;
            return desc;
        }
        return null;
    }

    protected List missingRequiredAttributes(List names) {
        ArrayList<String> val = new ArrayList<String>(this._attributes.size());
        ArrayList reqNames = new ArrayList(this._attributes.size());
        for (HtmlAttributeDesc desc : this._attributes) {
            if (!desc.isRequired()) continue;
            boolean found = false;
            for (String name : names) {
                if (!desc.nameMatches(name.toLowerCase())) continue;
                found = true;
                break;
            }
            if (found) continue;
            val.add(desc.getName());
        }
        return val;
    }

    protected boolean isCloseTagRequired() {
        return this._closeTagRequired;
    }

    protected boolean isContentEmpty() {
        return this._contentArray == null;
    }
}

