/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.pdf;

import edu.harvard.hul.ois.jhove.module.PdfModule;
import edu.harvard.hul.ois.jhove.module.pdf.PageObject;
import edu.harvard.hul.ois.jhove.module.pdf.PageTreeNode;
import edu.harvard.hul.ois.jhove.module.pdf.PdfArray;
import edu.harvard.hul.ois.jhove.module.pdf.PdfDictionary;
import edu.harvard.hul.ois.jhove.module.pdf.PdfException;
import edu.harvard.hul.ois.jhove.module.pdf.PdfIndirectObj;
import edu.harvard.hul.ois.jhove.module.pdf.PdfInvalidException;
import edu.harvard.hul.ois.jhove.module.pdf.PdfMalformedException;
import edu.harvard.hul.ois.jhove.module.pdf.PdfObject;
import java.io.IOException;

public abstract class DocNode {
    protected PdfModule _module;
    protected PageTreeNode _parent;
    protected PdfDictionary _dict;
    protected boolean _pageObjectFlag;
    protected boolean _walkFinished;

    public DocNode(PdfModule module, PageTreeNode parent, PdfDictionary dict) {
        this._module = module;
        this._parent = parent;
        this._dict = dict;
        PdfIndirectObj parentRef = (PdfIndirectObj)this._dict.get("Parent");
    }

    public boolean isPageObject() {
        return this._pageObjectFlag;
    }

    public abstract void startWalk();

    public abstract PageObject nextPageObject() throws PdfMalformedException;

    public abstract DocNode nextDocNode() throws PdfMalformedException;

    public DocNode getParent() {
        return this._parent;
    }

    public PdfDictionary getDict() {
        return this._dict;
    }

    public PdfDictionary getResources() throws PdfException {
        if (this._dict == null) {
            throw new PdfMalformedException("Missing dictionary in document node");
        }
        try {
            PdfObject resdict = this._dict.get("Resources");
            resdict = this._module.resolveIndirectObject(resdict);
            return (PdfDictionary)resdict;
        }
        catch (ClassCastException e) {
            throw new PdfInvalidException("Invalid Resources Entry in document");
        }
        catch (IOException f) {
            throw new PdfInvalidException("Invalid Resources Entry in document");
        }
    }

    public PdfDictionary getFontResources() throws PdfException {
        PdfDictionary resdict = this.getResources();
        if (resdict != null) {
            try {
                PdfObject fontdict = resdict.get("Font");
                fontdict = this._module.resolveIndirectObject(fontdict);
                return (PdfDictionary)fontdict;
            }
            catch (Exception e) {
                throw new PdfMalformedException("Invalid Font entry in Resources");
            }
        }
        return null;
    }

    public PdfArray getMediaBox() throws PdfInvalidException {
        try {
            PdfArray mbox = (PdfArray)this.get("MediaBox", true);
            if (mbox.toRectangle() != null) {
                return mbox;
            }
            throw new PdfInvalidException("Malformed MediaBox in page tree");
        }
        catch (Exception e) {
            throw new PdfInvalidException("Malformed MediaBox in page tree");
        }
    }

    public PdfObject get(String key, boolean inheritable) {
        PdfObject val = this._dict.get(key);
        if (val == null) {
            if (this._parent == null || !inheritable) {
                return null;
            }
            return this._parent.get(key, inheritable);
        }
        return val;
    }
}

