/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.tiff;

import edu.harvard.hul.ois.jhove.NisoImageMetadata;
import edu.harvard.hul.ois.jhove.module.tiff.IFD;
import edu.harvard.hul.ois.jhove.module.tiff.TiffIFD;
import edu.harvard.hul.ois.jhove.module.tiff.TiffProfileClassIT;

public final class TiffProfileClassITCT
extends TiffProfileClassIT {
    public TiffProfileClassITCT() {
        this._profileText = "TIFF/IT-CT (ISO 12639:1998)";
    }

    @Override
    public boolean satisfiesThisProfile(IFD ifd) {
        if (!super.satisfiesThisProfile(ifd)) {
            return false;
        }
        TiffIFD tifd = (TiffIFD)ifd;
        NisoImageMetadata niso = tifd.getNisoImageMetadata();
        if (niso.getBitsPerSample() == null || niso.getSamplesPerPixel() == -1 || niso.getSamplingFrequencyUnit() == -1) {
            return false;
        }
        if (!this.satisfiesPhotometricInterpretation(tifd, 5)) {
            return false;
        }
        if (!this.satisfiesCompression(tifd, new int[]{1, 32895})) {
            return false;
        }
        int inkSet = tifd.getInkSet();
        if (inkSet != 1 && inkSet != 2) {
            return false;
        }
        String seq = tifd.getColorSequence();
        if ((seq == null || "CMYK".equals(seq)) && inkSet != 1) {
            return false;
        }
        int spp = niso.getSamplesPerPixel();
        int numInks = tifd.getNumberOfInks();
        return numInks == -1 || numInks == spp;
    }
}

