/*
 * Decompiled with CFR 0.152.
 */
package net.byteseek.parser.regex;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import net.byteseek.parser.ParseException;
import net.byteseek.parser.Parser;
import net.byteseek.parser.StringParseReader;
import net.byteseek.parser.tree.ParseTree;
import net.byteseek.parser.tree.ParseTreeType;
import net.byteseek.parser.tree.node.BaseNode;
import net.byteseek.parser.tree.node.ByteNode;
import net.byteseek.parser.tree.node.ChildrenNode;
import net.byteseek.parser.tree.node.IntNode;
import net.byteseek.parser.tree.node.StringNode;
import net.byteseek.utils.ByteUtils;

public class RegexParser
implements Parser<ParseTree> {
    private static final char ANY = '.';
    private static final char ALTERNATIVE = '|';
    private static final char COMMENT = '#';
    private static final char STRING_QUOTE = '\'';
    private static final char CASE_INSENSITIVE_QUOTE = '`';
    private static final char ALL_BITMASK = '&';
    private static final char ANY_BITMASK = '~';
    private static final char SHORTHAND_ESCAPE = '\\';
    private static final char OPEN_SET = '[';
    private static final char INVERT = '^';
    private static final char RANGE_SEPARATOR = '-';
    private static final char CLOSE_SET = ']';
    private static final char OPTIONAL = '?';
    private static final char MANY = '*';
    private static final char ONE_TO_MANY = '+';
    private static final char OPEN_REPEAT = '{';
    private static final char REPEAT_SEPARATOR = ',';
    private static final char CLOSE_REPEAT = '}';
    private static final char OPEN_GROUP = '(';
    private static final char CLOSE_GROUP = ')';
    private static final boolean INVERTED = true;
    private static final boolean NOT_INVERTED = false;
    public static final ParseTree SPACE = ByteNode.valueOf((byte)32);
    public static final ParseTree UNDERSCORE = ByteNode.valueOf((byte)95);
    public static final ParseTree TAB = ByteNode.valueOf((byte)9);
    public static final ParseTree NEWLINE = ByteNode.valueOf((byte)10);
    public static final ParseTree CARRIAGE_RETURN = ByteNode.valueOf((byte)13);
    public static final ParseTree VERTICAL_TAB = ByteNode.valueOf((byte)11);
    public static final ParseTree FORM_FEED = ByteNode.valueOf((byte)12);
    public static final ParseTree ESCAPE = ByteNode.valueOf((byte)30);
    public static final ParseTree DIGITS_RANGE = RegexParser.buildRange((byte)48, (byte)57, false);
    public static final ParseTree NOT_DIGITS_RANGE = RegexParser.buildRange((byte)48, (byte)57, true);
    public static final ParseTree LOWERCASE_RANGE = RegexParser.buildRange((byte)97, (byte)122, false);
    public static final ParseTree NOT_LOWERCASE_RANGE = RegexParser.buildRange((byte)97, (byte)122, true);
    public static final ParseTree UPPERCASE_RANGE = RegexParser.buildRange((byte)65, (byte)90, false);
    public static final ParseTree NOT_UPPERCASE_RANGE = RegexParser.buildRange((byte)65, (byte)90, true);
    public static final ParseTree WHITESPACE_SET;
    public static final ParseTree NOT_WHITESPACE_SET;
    public static final ParseTree WORD_CHAR_SET;
    public static final ParseTree NOT_WORD_CHAR_SET;
    public static final ParseTree ASCII_RANGE;
    public static final ParseTree NOT_ASCII_RANGE;

    public static final ParseTree buildRange(byte minByte, byte maxByte, boolean inverted) {
        return new ChildrenNode(ParseTreeType.RANGE, RegexParser.buildList(ByteNode.valueOf(minByte), ByteNode.valueOf(maxByte)), inverted);
    }

    public static final ParseTree buildSet(ParseTree ... parseTrees) {
        return new ChildrenNode(ParseTreeType.SET, RegexParser.buildList(parseTrees));
    }

    public static final ParseTree buildInvertedSet(ParseTree ... parseTrees) {
        return new ChildrenNode(ParseTreeType.SET, RegexParser.buildList(parseTrees), true);
    }

    private static List<ParseTree> buildList(ParseTree ... parseTrees) {
        return Arrays.asList(parseTrees);
    }

    @Override
    public ParseTree parse(String expression) throws ParseException {
        if (expression == null || expression.isEmpty()) {
            throw new ParseException("Null or empty expression not allowed.");
        }
        return this.parseAlternatives(new StringParseReader(expression));
    }

    private ParseTree parseAlternatives(StringParseReader expression) throws ParseException {
        ArrayList<ParseTree> alternatives = new ArrayList<ParseTree>(8);
        while (!expression.atEnd() && expression.peekBehind() != 41) {
            alternatives.add(this.parseSequence(expression));
        }
        return this.optimisedAlternatives(alternatives, expression);
    }

    private ParseTree optimisedAlternatives(List<ParseTree> alternatives, StringParseReader expression) throws ParseException {
        int numAlternatives = alternatives.size();
        if (numAlternatives == 0) {
            throw new ParseException(this.addContext("No alternatives were found.", expression));
        }
        if (numAlternatives == 1) {
            return alternatives.get(0);
        }
        ParseTree optimisedSet = this.optimiseSingleByteAlternatives(alternatives);
        if (alternatives.size() == 0) {
            return optimisedSet;
        }
        if (optimisedSet != null) {
            alternatives.add(optimisedSet);
        }
        return new ChildrenNode(ParseTreeType.ALTERNATIVES, alternatives);
    }

    private ParseTree optimiseSingleByteAlternatives(List<ParseTree> alternatives) {
        int numOptimisableAlternatives = 0;
        for (ParseTree alternative : alternatives) {
            if (!this.matchesSingleByteLength(alternative)) continue;
            ++numOptimisableAlternatives;
        }
        if (numOptimisableAlternatives > 1) {
            ArrayList<ParseTree> setChildren = new ArrayList<ParseTree>(numOptimisableAlternatives);
            Iterator<ParseTree> altIterator = alternatives.iterator();
            while (altIterator.hasNext()) {
                ParseTree currentAlternative = altIterator.next();
                if (!this.matchesSingleByteLength(currentAlternative)) continue;
                setChildren.add(currentAlternative);
                altIterator.remove();
            }
            return new ChildrenNode(ParseTreeType.SET, setChildren);
        }
        return null;
    }

    private boolean matchesSingleByteLength(ParseTree node) {
        switch (node.getParseTreeType()) {
            case BYTE: 
            case RANGE: 
            case SET: 
            case ANY: 
            case ALL_BITMASK: 
            case ANY_BITMASK: {
                return true;
            }
        }
        return false;
    }

    private ParseTree parseSequence(StringParseReader expression) throws ParseException {
        ArrayList<ParseTree> sequenceNodes = new ArrayList<ParseTree>();
        int currentChar = expression.read();
        boolean requireRangeValue = false;
        block5: while (currentChar >= 0) {
            if (this.foundQuantifiedAtoms(currentChar, expression, sequenceNodes)) {
                if (requireRangeValue) {
                    this.createRange(sequenceNodes, expression);
                    requireRangeValue = false;
                }
            } else if (!this.foundWhitespaceAndComments(currentChar, expression)) {
                if (requireRangeValue) {
                    throw new ParseException(this.addContext("A range value was expected", expression));
                }
                switch (currentChar) {
                    case 40: {
                        sequenceNodes.add(this.parseAlternatives(expression));
                        break;
                    }
                    case 41: 
                    case 124: {
                        break block5;
                    }
                    case 45: {
                        requireRangeValue = true;
                        break;
                    }
                    default: {
                        throw new ParseException(this.addContext("Unexpected character [" + (char)currentChar + ']', expression));
                    }
                }
            }
            currentChar = expression.read();
        }
        if (requireRangeValue) {
            throw new ParseException(this.addContext("Cannot have a range without a second value.", expression));
        }
        if (sequenceNodes.isEmpty()) {
            throw new ParseException(this.addContext("Cannot have an empty sequence", expression));
        }
        return sequenceNodes.size() == 1 ? (ParseTree)sequenceNodes.get(0) : new ChildrenNode(ParseTreeType.SEQUENCE, sequenceNodes);
    }

    private void createRange(List<ParseTree> sequence, StringParseReader expression) throws ParseException {
        ParseTree secondRangeValue = this.popLastNode(sequence, expression);
        if (secondRangeValue.getParseTreeType() != ParseTreeType.BYTE) {
            throw new ParseException(this.addContext("The second range value must be of type BYTE: " + secondRangeValue, expression));
        }
        if (secondRangeValue.isValueInverted()) {
            throw new ParseException(this.addContext("The second value of a range cannot be inverted " + secondRangeValue, expression));
        }
        ParseTree firstRangeValue = this.popLastNode(sequence, expression);
        if (firstRangeValue.getParseTreeType() != ParseTreeType.BYTE) {
            throw new ParseException(this.addContext("The first range value must be of type BYTE: " + firstRangeValue, expression));
        }
        sequence.add(new ChildrenNode(ParseTreeType.RANGE, firstRangeValue.isValueInverted(), ByteNode.valueOf(firstRangeValue.getByteValue()), ByteNode.valueOf(secondRangeValue.getByteValue())));
    }

    private ParseTree popLastNode(List<ParseTree> sequence, StringParseReader expression) throws ParseException {
        if (sequence.isEmpty()) {
            throw new ParseException(this.addContext("Tried to remove the last node in a sequence, but it was empty", expression));
        }
        return sequence.remove(sequence.size() - 1);
    }

    private boolean foundWhitespaceAndComments(int currentChar, StringParseReader expression) {
        switch (currentChar) {
            case 9: 
            case 10: 
            case 13: 
            case 32: {
                return true;
            }
            case 35: {
                expression.readPastChar('\n');
                return true;
            }
        }
        return false;
    }

    private boolean foundAtoms(int currentChar, StringParseReader expression, List<ParseTree> nodes) throws ParseException {
        ParseTree node;
        boolean inverted = false;
        int charToMatch = currentChar;
        if (charToMatch == 94) {
            inverted = true;
            charToMatch = expression.read();
        }
        if ((node = this.matchAtoms(charToMatch, expression, inverted)) != null) {
            nodes.add(node);
        }
        return node != null;
    }

    private boolean foundQuantifiedAtoms(int currentChar, StringParseReader expression, List<ParseTree> nodes) throws ParseException {
        ParseTree node;
        boolean inverted = false;
        int charToMatch = currentChar;
        if (charToMatch == 94) {
            inverted = true;
            charToMatch = expression.read();
        }
        if ((node = this.matchAtoms(charToMatch, expression, inverted)) != null) {
            nodes.add(node);
        } else {
            node = this.matchQuantifiers(charToMatch, expression, nodes);
            if (node != null) {
                nodes.add(node);
            }
        }
        return node != null;
    }

    private void checkQuantifiable(ParseTree node, StringParseReader expression) throws ParseException {
        switch (node.getParseTreeType()) {
            case BYTE: 
            case RANGE: 
            case SET: 
            case ANY: 
            case ALL_BITMASK: 
            case ANY_BITMASK: 
            case SEQUENCE: 
            case ALTERNATIVES: 
            case STRING: 
            case CASE_INSENSITIVE_STRING: {
                return;
            }
        }
        throw new ParseException(this.addContext("The node: " + node + " is not quantifiable", expression));
    }

    private ParseTree matchAtoms(int currentChar, StringParseReader expression, boolean inverted) throws ParseException {
        switch (currentChar) {
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: {
                return ByteNode.valueOf(expression.readHexByte(currentChar), inverted);
            }
            case 46: {
                return BaseNode.ANY_NODE;
            }
            case 38: {
                return new ByteNode(ParseTreeType.ALL_BITMASK, expression.readHexByte(), inverted);
            }
            case 126: {
                return new ByteNode(ParseTreeType.ANY_BITMASK, expression.readHexByte(), inverted);
            }
            case 39: {
                String stringValue = expression.readString('\'');
                if (stringValue.length() == 1) {
                    return ByteNode.valueOf(ByteUtils.getBytes(stringValue)[0], inverted);
                }
                if (inverted) {
                    throw new ParseException(this.addContext("Strings cannot be inverted", expression));
                }
                return new StringNode(stringValue);
            }
            case 96: {
                String stringValue = expression.readString('`');
                if (inverted) {
                    throw new ParseException(this.addContext("Case insensitive strings cannot be inverted", expression));
                }
                return new StringNode(stringValue, ParseTreeType.CASE_INSENSITIVE_STRING);
            }
            case 92: {
                return this.parseShorthand(expression, inverted);
            }
            case 91: {
                return this.parseSet(expression, inverted);
            }
        }
        return null;
    }

    private ParseTree parseShorthand(StringParseReader expression, boolean inverted) throws ParseException {
        int character = expression.read();
        switch (character) {
            case 116: {
                return inverted ? ByteNode.valueOf((byte)9, true) : TAB;
            }
            case 110: {
                return inverted ? ByteNode.valueOf((byte)10, true) : NEWLINE;
            }
            case 114: {
                return inverted ? ByteNode.valueOf((byte)13, true) : CARRIAGE_RETURN;
            }
            case 118: {
                return inverted ? ByteNode.valueOf((byte)11, true) : VERTICAL_TAB;
            }
            case 102: {
                return inverted ? ByteNode.valueOf((byte)12, true) : FORM_FEED;
            }
            case 101: {
                return inverted ? ByteNode.valueOf((byte)30, true) : ESCAPE;
            }
            case 100: {
                return inverted ? NOT_DIGITS_RANGE : DIGITS_RANGE;
            }
            case 68: {
                return inverted ? DIGITS_RANGE : NOT_DIGITS_RANGE;
            }
            case 119: {
                return inverted ? NOT_WORD_CHAR_SET : WORD_CHAR_SET;
            }
            case 87: {
                return inverted ? WORD_CHAR_SET : NOT_WORD_CHAR_SET;
            }
            case 115: {
                return inverted ? NOT_WHITESPACE_SET : WHITESPACE_SET;
            }
            case 83: {
                return inverted ? WHITESPACE_SET : NOT_WHITESPACE_SET;
            }
            case 108: {
                return inverted ? NOT_LOWERCASE_RANGE : LOWERCASE_RANGE;
            }
            case 76: {
                return inverted ? LOWERCASE_RANGE : NOT_LOWERCASE_RANGE;
            }
            case 117: {
                return inverted ? NOT_UPPERCASE_RANGE : UPPERCASE_RANGE;
            }
            case 85: {
                return inverted ? UPPERCASE_RANGE : NOT_UPPERCASE_RANGE;
            }
            case 105: {
                return inverted ? NOT_ASCII_RANGE : ASCII_RANGE;
            }
            case 73: {
                return inverted ? ASCII_RANGE : NOT_ASCII_RANGE;
            }
        }
        throw new ParseException(this.addContext("Unexpected shorthand character [" + (char)character + ']', expression));
    }

    private ParseTree parseSet(StringParseReader expression, boolean inverted) throws ParseException {
        ArrayList<ParseTree> setNodes = new ArrayList<ParseTree>();
        int currentChar = expression.read();
        boolean requireRangeValue = false;
        while (currentChar >= 0) {
            if (this.foundAtoms(currentChar, expression, setNodes)) {
                if (requireRangeValue) {
                    this.createRange(setNodes, expression);
                    requireRangeValue = false;
                }
            } else if (!this.foundWhitespaceAndComments(currentChar, expression)) {
                if (currentChar == 93) break;
                if (currentChar == 45) {
                    requireRangeValue = true;
                } else {
                    throw new ParseException(this.addContext("Unexpected character [" + (char)currentChar + ']', expression));
                }
            }
            currentChar = expression.read();
        }
        if (requireRangeValue) {
            throw new ParseException(this.addContext("Cannot have a range without a second value.", expression));
        }
        if (currentChar < 0) {
            throw new ParseException(this.addContext("The expression ended without closing the set", expression));
        }
        if (setNodes.isEmpty()) {
            throw new ParseException(this.addContext("Cannot have an empty set", expression));
        }
        return new ChildrenNode(ParseTreeType.SET, setNodes, inverted);
    }

    private ParseTree matchQuantifiers(int currentChar, StringParseReader expression, List<ParseTree> nodes) throws ParseException {
        ParseTree quantifier = null;
        if (nodes.size() > 0) {
            ParseTree nodeToQuantify = nodes.get(nodes.size() - 1);
            switch (currentChar) {
                case 42: {
                    quantifier = new ChildrenNode(ParseTreeType.ZERO_TO_MANY, nodeToQuantify);
                    break;
                }
                case 43: {
                    quantifier = new ChildrenNode(ParseTreeType.ONE_TO_MANY, nodeToQuantify);
                    break;
                }
                case 123: {
                    quantifier = this.parseRepeat(expression, nodeToQuantify);
                    break;
                }
                case 63: {
                    quantifier = new ChildrenNode(ParseTreeType.OPTIONAL, nodeToQuantify);
                }
            }
            if (quantifier != null) {
                this.checkQuantifiable(nodeToQuantify, expression);
                nodes.remove(nodes.size() - 1);
            }
        }
        return quantifier;
    }

    private ParseTree parseRepeat(StringParseReader expression, ParseTree nodeToRepeat) throws ParseException {
        int firstValue = expression.readInt();
        int nextToken = expression.read();
        if (nextToken == 125) {
            if (firstValue == 0) {
                throw new ParseException(this.addContext("Single repeat value cannot be zero", expression));
            }
            return new ChildrenNode(ParseTreeType.REPEAT, new IntNode(firstValue), nodeToRepeat);
        }
        if (nextToken == 44) {
            ChildrenNode repeatNode;
            if (expression.peekAhead() == 42) {
                expression.read();
                repeatNode = new ChildrenNode(ParseTreeType.REPEAT_MIN_TO_MANY, new IntNode(firstValue), nodeToRepeat);
            } else {
                repeatNode = new ChildrenNode(ParseTreeType.REPEAT_MIN_TO_MAX, new IntNode(firstValue), new IntNode(expression.readInt()), nodeToRepeat);
            }
            nextToken = expression.read();
            if (nextToken == 125) {
                return repeatNode;
            }
            throw new ParseException(this.addContext("No closing } for repeat instruction " + repeatNode, expression));
        }
        throw new ParseException(this.addContext("No closing } for repeat instruction with firstValue " + firstValue, expression));
    }

    private String addContext(String description, StringParseReader expression) {
        return description + ".  Error occurred at position [" + expression.getPosition() + "] in expression [" + expression + ']';
    }

    static {
        ASCII_RANGE = RegexParser.buildRange((byte)0, (byte)127, false);
        NOT_ASCII_RANGE = RegexParser.buildRange((byte)0, (byte)127, true);
        WHITESPACE_SET = RegexParser.buildSet(SPACE, TAB, NEWLINE, CARRIAGE_RETURN);
        NOT_WHITESPACE_SET = RegexParser.buildInvertedSet(SPACE, TAB, NEWLINE, CARRIAGE_RETURN);
        WORD_CHAR_SET = RegexParser.buildSet(DIGITS_RANGE, LOWERCASE_RANGE, UPPERCASE_RANGE, UNDERSCORE);
        NOT_WORD_CHAR_SET = RegexParser.buildInvertedSet(DIGITS_RANGE, LOWERCASE_RANGE, UPPERCASE_RANGE, UNDERSCORE);
    }
}

