/*
 * Decompiled with CFR 0.152.
 */
package net.byteseek.parser.tree.node;

import net.byteseek.parser.ParseException;
import net.byteseek.parser.tree.ParseTreeType;
import net.byteseek.parser.tree.node.BaseNode;

public final class StringNode
extends BaseNode {
    private String value;

    public StringNode(String value) {
        this(value, ParseTreeType.STRING);
    }

    public StringNode(String value, ParseTreeType type) {
        super(type);
        if (type != ParseTreeType.STRING && type != ParseTreeType.CASE_INSENSITIVE_STRING) {
            throw new IllegalArgumentException("A StringNode can only be of type STRING or CASE_INSENSITIVE_STRING. The type passed in was [" + (Object)((Object)type) + ']');
        }
        this.value = value == null ? "" : value;
    }

    @Override
    public String getTextValue() throws ParseException {
        return this.value;
    }

    public boolean isCaseSensitive() {
        return this.getParseTreeType() == ParseTreeType.STRING;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + '[' + (Object)((Object)this.getParseTreeType()) + ", value:" + this.value + ']';
    }
}

