/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.core.interfaces.archive;

import com.github.junrar.Archive;
import com.github.junrar.Volume;
import com.github.junrar.VolumeManager;
import com.github.junrar.io.IReadOnlyAccess;
import java.io.EOFException;
import java.io.IOException;
import net.byteseek.io.reader.WindowReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.gov.nationalarchives.droid.core.interfaces.archive.ArchiveFileUtils;

public class RarReader
implements VolumeManager {
    private static final String IOEXCEPTION_MSG = "IOException when reading length of reader: ";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final WindowReader reader;

    public RarReader(WindowReader reader) {
        this.reader = reader;
    }

    public Volume nextArchive(Archive archive, Volume lastVolume) throws IOException {
        return lastVolume == null ? new ReaderVolume(archive) : null;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.reader + ")";
    }

    private class ReaderVolume
    implements Volume {
        private final Archive archive;

        public ReaderVolume(Archive archive) {
            this.archive = archive;
        }

        public IReadOnlyAccess getReadOnlyAccess() throws IOException {
            return new ReaderReadOnlyAccess();
        }

        public long getLength() {
            try {
                return RarReader.this.reader.length();
            }
            catch (IOException e) {
                RarReader.this.log.error(RarReader.IOEXCEPTION_MSG + RarReader.this.reader, (Throwable)e);
                throw new RuntimeException(RarReader.IOEXCEPTION_MSG + RarReader.this.reader, e);
            }
        }

        public Archive getArchive() {
            return this.archive;
        }

        private class ReaderReadOnlyAccess
        implements IReadOnlyAccess {
            private long position;

            private ReaderReadOnlyAccess() {
            }

            public long getPosition() throws IOException {
                return this.position;
            }

            public void setPosition(long pos) throws IOException {
                if (pos < 0L) {
                    throw new IOException("Cannot seek to a negative position.");
                }
                this.position = pos;
            }

            public int read() throws IOException {
                return RarReader.this.reader.readByte(this.position++);
            }

            public int read(byte[] buffer, int off, int count) throws IOException {
                int bytesCopied = ArchiveFileUtils.copyToBuffer(RarReader.this.reader, this.position, buffer, off, count);
                this.position += (long)bytesCopied;
                return bytesCopied;
            }

            public int readFully(byte[] buffer, int count) throws IOException {
                int bytesCopied = this.read(buffer, 0, count);
                if (bytesCopied != count) {
                    throw new EOFException("Read " + bytesCopied + " bytes instead of the requested " + count);
                }
                return bytesCopied;
            }

            public void close() throws IOException {
            }
        }
    }
}

