/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.graphics;

import java.awt.Color;
import java.awt.color.ColorSpace;
import java.util.HashMap;
import java.util.List;
import org.icepdf.core.pobjects.Name;
import org.icepdf.core.pobjects.graphics.PColorSpace;
import org.icepdf.core.util.Library;

public class CalGray
extends PColorSpace {
    public static final Name WHITE_POINT_KEY = new Name("WhitePoint");
    public static final Name GAMMA_KEY = new Name("Gamma");
    public static final Name MATRIX_KEY = new Name("Matrix");
    public static final Name CAL_GRAY_KEY = new Name("CalGray");
    private static ColorSpace grayCS = ColorSpace.getInstance(1003);
    protected float[] whitepoint = new float[]{1.0f, 1.0f, 1.0f};
    protected float gamma = 1.0f;

    public CalGray(Library l, HashMap h) {
        super(l, h);
        Object o;
        List m = (List)h.get(WHITE_POINT_KEY);
        if (m != null) {
            for (int i = 0; i < 3; ++i) {
                this.whitepoint[i] = ((Number)m.get(i)).floatValue();
            }
        }
        if ((o = h.get(GAMMA_KEY)) instanceof Float) {
            this.gamma = ((Float)o).floatValue();
        }
    }

    public Color getColor(float[] f, boolean fillAndStroke) {
        float A = (float)Math.pow(f[0], this.gamma);
        float X = this.whitepoint[0] * A;
        float Y = this.whitepoint[1] * A;
        float Z = this.whitepoint[2] * A;
        if (X < 0.0f) {
            X = 0.0f;
        }
        if (Y < 0.0f) {
            Y = 0.0f;
        }
        if (Z < 0.0f) {
            Z = 0.0f;
        }
        if (X > 1.0f) {
            X = 1.0f;
        }
        if (Y > 1.0f) {
            Y = 1.0f;
        }
        if (Z > 1.0f) {
            Z = 1.0f;
        }
        Color tmp = new Color(grayCS, new float[]{Z, Y, Z}, 1.0f);
        return tmp;
    }

    public int getNumComponents() {
        return 1;
    }
}

