/*
 * Decompiled with CFR 0.152.
 */
package net.byteseek.io.reader;

import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import net.byteseek.io.IOUtils;
import net.byteseek.io.reader.AbstractReader;
import net.byteseek.io.reader.cache.LeastRecentlyUsedCache;
import net.byteseek.io.reader.cache.WindowCache;
import net.byteseek.io.reader.windows.HardWindow;
import net.byteseek.io.reader.windows.SoftWindow;
import net.byteseek.io.reader.windows.SoftWindowRecovery;
import net.byteseek.io.reader.windows.Window;
import net.byteseek.utils.ArgUtils;

public class FileReader
extends AbstractReader
implements SoftWindowRecovery {
    private static final String READ_ONLY = "r";
    private final File file;
    private final RandomAccessFile randomAccessFile;
    private final long length;
    private boolean useSoftWindows;

    public FileReader(File file) throws FileNotFoundException {
        this(file, 4096, new LeastRecentlyUsedCache(32));
    }

    public FileReader(File file, WindowCache cache) throws FileNotFoundException {
        this(file, 4096, cache);
    }

    public FileReader(File file, int windowSize) throws FileNotFoundException {
        this(file, windowSize, new LeastRecentlyUsedCache(32));
    }

    public FileReader(File file, int windowSize, int capacity) throws FileNotFoundException {
        this(file, windowSize, new LeastRecentlyUsedCache(capacity));
    }

    public FileReader(String path) throws FileNotFoundException {
        this(path == null ? null : new File(path), 4096, new LeastRecentlyUsedCache(32));
    }

    public FileReader(String path, WindowCache cache) throws FileNotFoundException {
        this(path == null ? null : new File(path), 4096, cache);
    }

    public FileReader(String path, int windowSize) throws FileNotFoundException {
        this(path == null ? null : new File(path), windowSize, new LeastRecentlyUsedCache(32));
    }

    public FileReader(String path, int windowSize, int capacity) throws FileNotFoundException {
        this(path == null ? null : new File(path), windowSize, new LeastRecentlyUsedCache(capacity));
    }

    public FileReader(File file, int windowSize, WindowCache cache) throws FileNotFoundException {
        super(windowSize, cache);
        ArgUtils.checkNullObject(file, "file");
        this.file = file;
        this.randomAccessFile = new RandomAccessFile(file, READ_ONLY);
        this.length = file.length();
    }

    @Override
    public final long length() {
        return this.length;
    }

    @Override
    protected Window createWindow(long windowStart) throws IOException {
        if (windowStart >= 0L) {
            try {
                this.randomAccessFile.seek(windowStart);
                byte[] bytes = new byte[this.windowSize];
                int totalRead = IOUtils.readBytes(this.randomAccessFile, bytes);
                if (totalRead > 0) {
                    return this.useSoftWindows ? new SoftWindow(bytes, windowStart, totalRead, this) : new HardWindow(bytes, windowStart, totalRead);
                }
            }
            catch (EOFException eOFException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public void close() throws IOException {
        try {
            this.randomAccessFile.close();
        }
        finally {
            super.close();
        }
    }

    public final File getFile() {
        return this.file;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[file:" + this.file + " length: " + this.file.length() + " cache:" + this.cache + ']';
    }

    public void useSoftWindows(boolean useSoftWindows) {
        this.useSoftWindows = useSoftWindows;
    }

    @Override
    public byte[] reloadWindowBytes(Window window) throws IOException {
        this.randomAccessFile.seek(window.getWindowPosition());
        byte[] bytes = new byte[this.windowSize];
        IOUtils.readBytes(this.randomAccessFile, bytes);
        return bytes;
    }
}

