/*
 * Decompiled with CFR 0.152.
 */
package net.byteseek.matcher.sequence;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import net.byteseek.io.reader.WindowReader;
import net.byteseek.io.reader.windows.Window;
import net.byteseek.matcher.bytes.ByteMatcher;
import net.byteseek.matcher.sequence.SequenceMatcher;
import net.byteseek.utils.ArgUtils;

public final class SequenceSequenceMatcher
implements SequenceMatcher {
    private final SequenceMatcher[] matchers;
    private final int totalLength;

    public SequenceSequenceMatcher(List<? extends SequenceMatcher> matchList) {
        this(1, matchList);
    }

    public SequenceSequenceMatcher(int numberOfRepeats, List<? extends SequenceMatcher> matcherCollection) {
        ArgUtils.checkNullOrEmptyCollectionNoNullElements(matcherCollection);
        ArgUtils.checkPositiveInteger(numberOfRepeats);
        if (numberOfRepeats == 1) {
            this.matchers = matcherCollection.toArray(new SequenceMatcher[matcherCollection.size() * numberOfRepeats]);
            this.totalLength = this.calculateTotalLength(this.matchers);
        } else {
            int length = matcherCollection.size() * numberOfRepeats;
            ArrayList<? extends SequenceMatcher> allMatchers = new ArrayList<SequenceMatcher>(length);
            for (int count = 0; count < numberOfRepeats; ++count) {
                allMatchers.addAll(matcherCollection);
            }
            this.matchers = allMatchers.toArray(new SequenceMatcher[length]);
            this.totalLength = this.calculateTotalLength(this.matchers);
        }
    }

    public SequenceSequenceMatcher(SequenceMatcher ... matchers) {
        this(1, matchers);
    }

    public SequenceSequenceMatcher(int numberOfRepeats, SequenceMatcher ... matchArray) {
        ArgUtils.checkNullOrEmptyArrayNoNullElements(matchArray);
        ArgUtils.checkPositiveInteger(numberOfRepeats);
        if (numberOfRepeats == 1) {
            this.matchers = (SequenceMatcher[])matchArray.clone();
            this.totalLength = this.calculateTotalLength(this.matchers);
        } else {
            int numberOfMatchers = matchArray.length;
            int length = numberOfMatchers * numberOfRepeats;
            this.matchers = new SequenceMatcher[length];
            for (int repeat = 0; repeat < numberOfRepeats; ++repeat) {
                System.arraycopy(matchArray, 0, this.matchers, repeat * numberOfMatchers, numberOfMatchers);
            }
            this.totalLength = this.calculateTotalLength(this.matchers);
        }
    }

    @Override
    public boolean matches(WindowReader reader, long matchPosition) throws IOException {
        int localTotalLength = this.totalLength;
        SequenceMatcher[] localArray = this.matchers;
        Window window = reader.getWindow(matchPosition);
        int matchPos = 0;
        int matcherIndex = 0;
        while (window != null) {
            int matcherLength;
            int windowStartMatchPos = matchPos;
            int offset = reader.getWindowOffset(matchPosition + (long)matchPos);
            int endArrayPos = Math.min(window.length(), offset + localTotalLength - matchPos);
            byte[] array = window.getArray();
            for (int arrayCheckPos = offset + matchPos - windowStartMatchPos; arrayCheckPos < endArrayPos; arrayCheckPos += matcherLength) {
                SequenceMatcher matcher;
                if (arrayCheckPos + (matcherLength = (matcher = localArray[matcherIndex++]).length()) <= endArrayPos ? !matcher.matchesNoBoundsCheck(array, arrayCheckPos) : !matcher.matches(reader, matchPosition + (long)matchPos)) {
                    return false;
                }
                matchPos += matcherLength;
            }
            if (matchPos == localTotalLength) {
                return true;
            }
            window = reader.getWindow(matchPosition + (long)matchPos);
        }
        return false;
    }

    @Override
    public boolean matches(byte[] bytes, int matchPosition) {
        if (matchPosition + this.totalLength <= bytes.length && matchPosition >= 0) {
            SequenceMatcher[] localMatchers;
            int matchAt = matchPosition;
            for (SequenceMatcher matcher : localMatchers = this.matchers) {
                if (matcher.matchesNoBoundsCheck(bytes, matchAt)) {
                    matchAt += matcher.length();
                    continue;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean matchesNoBoundsCheck(byte[] bytes, int matchPosition) {
        SequenceMatcher[] localMatchers;
        int matchAt = matchPosition;
        for (SequenceMatcher matcher : localMatchers = this.matchers) {
            if (matcher.matchesNoBoundsCheck(bytes, matchAt)) {
                matchAt += matcher.length();
                continue;
            }
            return false;
        }
        return true;
    }

    @Override
    public int length() {
        return this.totalLength;
    }

    @Override
    public String toRegularExpression(boolean prettyPrint) {
        StringBuilder regularExpression = new StringBuilder();
        boolean firstMatcher = true;
        for (SequenceMatcher matcher : this.matchers) {
            if (!firstMatcher && prettyPrint) {
                regularExpression.append(' ');
            }
            regularExpression.append(matcher.toRegularExpression(prettyPrint));
            firstMatcher = false;
        }
        return regularExpression.toString();
    }

    @Override
    public ByteMatcher getMatcherForPosition(int position) {
        ArgUtils.checkIndexOutOfBounds(this.totalLength, position);
        int currentEndPosition = 0;
        ByteMatcher result = null;
        for (SequenceMatcher matcher : this.matchers) {
            int matcherLength = matcher.length();
            if (position >= (currentEndPosition += matcherLength)) continue;
            int matcherOffset = position - (currentEndPosition - matcherLength);
            result = matcher.getMatcherForPosition(matcherOffset);
            break;
        }
        return result;
    }

    @Override
    public SequenceSequenceMatcher reverse() {
        SequenceMatcher[] reversed = new SequenceMatcher[this.matchers.length];
        int position = this.matchers.length - 1;
        for (SequenceMatcher matcher : this.matchers) {
            reversed[position--] = matcher.reverse();
        }
        return new SequenceSequenceMatcher(reversed);
    }

    @Override
    public SequenceMatcher subsequence(int beginIndex, int endIndex) {
        ArgUtils.checkIndexOutOfBounds(this.totalLength, beginIndex, endIndex);
        SequenceMatcher startMatcher = null;
        SequenceMatcher endMatcher = null;
        int startOffset = 0;
        int endLimit = 0;
        int startIndex = 0;
        int lastIndex = 0;
        int currentEndPosition = 0;
        int startPosition = beginIndex;
        int endPosition = endIndex - 1;
        for (int matcherIndex = 0; matcherIndex < this.matchers.length; ++matcherIndex) {
            SequenceMatcher matcher = this.matchers[matcherIndex];
            int matcherLength = matcher.length();
            if (startPosition < (currentEndPosition += matcherLength)) {
                startMatcher = matcher;
                startOffset = beginIndex - (currentEndPosition - matcherLength);
                startIndex = matcherIndex;
                startPosition = Integer.MAX_VALUE;
            }
            if (endPosition >= currentEndPosition) continue;
            endMatcher = matcher;
            endLimit = endIndex - (currentEndPosition - matcherLength);
            lastIndex = matcherIndex;
            break;
        }
        if (startIndex == lastIndex) {
            return startMatcher.subsequence(startOffset, endLimit);
        }
        int newSize = lastIndex - startIndex + 1;
        SequenceMatcher[] newSequence = new SequenceMatcher[newSize];
        newSequence[0] = startMatcher.subsequence(startOffset, startMatcher.length());
        newSequence[newSize - 1] = endMatcher.subsequence(0, endLimit);
        if (newSize > 2) {
            System.arraycopy(this.matchers, startIndex + 1, newSequence, 1, newSize - 2);
        }
        return new SequenceSequenceMatcher(newSequence);
    }

    @Override
    public SequenceMatcher subsequence(int beginIndex) {
        return this.subsequence(beginIndex, this.length());
    }

    @Override
    public SequenceMatcher repeat(int numberOfRepeats) {
        ArgUtils.checkPositiveInteger(numberOfRepeats);
        if (numberOfRepeats == 1) {
            return this;
        }
        return new SequenceSequenceMatcher(numberOfRepeats, this.matchers);
    }

    public String toString() {
        return this.getClass().getSimpleName() + '[' + this.toRegularExpression(true) + ']';
    }

    @Override
    public Iterator<ByteMatcher> iterator() {
        return new SequenceSequenceIterator();
    }

    private int calculateTotalLength(SequenceMatcher[] matchers) {
        int totalLength = 0;
        for (SequenceMatcher matcher : matchers) {
            totalLength += matcher.length();
        }
        return totalLength;
    }

    private class SequenceSequenceIterator
    implements Iterator<ByteMatcher> {
        private int position;

        private SequenceSequenceIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.position < SequenceSequenceMatcher.this.totalLength;
        }

        @Override
        public ByteMatcher next() {
            if (this.hasNext()) {
                return SequenceSequenceMatcher.this.getMatcherForPosition(this.position++);
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Cannot remove byte matchers from SequenceSequenceMatchers");
        }
    }
}

