/*
 * Decompiled with CFR 0.152.
 */
package net.byteseek.searcher;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.byteseek.io.reader.WindowReader;
import net.byteseek.matcher.sequence.SequenceMatcher;
import net.byteseek.searcher.BackwardSearchIterator;
import net.byteseek.searcher.ForwardSearchIterator;
import net.byteseek.searcher.SearchResult;
import net.byteseek.searcher.Searcher;

public final class SearchUtils {
    private SearchUtils() {
    }

    public static <T> List<SearchResult<T>> searchAllForwards(Searcher<T> searcher, byte[] bytes) {
        ArrayList<SearchResult<T>> results = new ArrayList<SearchResult<T>>();
        ForwardSearchIterator<T> iterator = new ForwardSearchIterator<T>(searcher, bytes);
        while (iterator.hasNext()) {
            results.addAll((Collection<SearchResult<T>>)iterator.next());
        }
        return results;
    }

    public static <T> List<SearchResult<T>> searchAllForwards(Searcher<T> searcher, WindowReader reader) {
        ArrayList<SearchResult<T>> results = new ArrayList<SearchResult<T>>();
        ForwardSearchIterator<T> iterator = new ForwardSearchIterator<T>(searcher, reader);
        while (iterator.hasNext()) {
            results.addAll((Collection<SearchResult<T>>)iterator.next());
        }
        return results;
    }

    public static <T> List<SearchResult<T>> searchAllBackwards(Searcher<T> searcher, byte[] bytes) {
        ArrayList<SearchResult<T>> results = new ArrayList<SearchResult<T>>();
        BackwardSearchIterator<T> iterator = new BackwardSearchIterator<T>(searcher, bytes);
        while (iterator.hasNext()) {
            results.addAll((Collection<SearchResult<T>>)iterator.next());
        }
        return results;
    }

    public static <T> List<SearchResult<T>> searchAllBackwards(Searcher<T> searcher, WindowReader reader) throws IOException {
        ArrayList<SearchResult<T>> results = new ArrayList<SearchResult<T>>();
        BackwardSearchIterator<T> iterator = new BackwardSearchIterator<T>(searcher, reader);
        while (iterator.hasNext()) {
            results.addAll((Collection<SearchResult<T>>)iterator.next());
        }
        return results;
    }

    public static <T> List<SearchResult<T>> singleResult(long matchPosition, T matchingObject) {
        ArrayList<SearchResult<T>> result = new ArrayList<SearchResult<T>>(1);
        result.add(new SearchResult<T>(matchPosition, matchingObject));
        return result;
    }

    public static <T> List<SearchResult<T>> resultsAtPosition(long matchPosition, Collection<T> matchingObjects) {
        ArrayList<SearchResult<T>> results = new ArrayList<SearchResult<T>>(matchingObjects.size());
        for (T matchingObject : matchingObjects) {
            results.add(new SearchResult<T>(matchPosition, matchingObject));
        }
        return results;
    }

    public static List<SearchResult<SequenceMatcher>> resultsBackFromPosition(long backFromPosition, Collection<? extends SequenceMatcher> matchingSequences, long searchStart, long searchEnd) {
        ArrayList<SearchResult<SequenceMatcher>> results = new ArrayList<SearchResult<SequenceMatcher>>(matchingSequences.size());
        long onePastBackFrom = backFromPosition + 1L;
        for (SequenceMatcher sequenceMatcher : matchingSequences) {
            long sequenceStartPosition = onePastBackFrom - (long)sequenceMatcher.length();
            if (sequenceStartPosition < searchStart || sequenceStartPosition > searchEnd) continue;
            results.add(new SearchResult<SequenceMatcher>(sequenceStartPosition, sequenceMatcher));
        }
        return results;
    }

    public static <T> List<SearchResult<T>> noResults() {
        return Collections.emptyList();
    }

    public static <T> List<SearchResult<T>> addPositionToResults(List<SearchResult<T>> originalResults, long amountToAdd) {
        int numResults = originalResults.size();
        ArrayList<SearchResult<T>> newResults = new ArrayList<SearchResult<T>>(numResults);
        for (int i = 0; i < numResults; ++i) {
            SearchResult<T> result = originalResults.get(i);
            newResults.add(new SearchResult<T>(result.getMatchPosition() + amountToAdd, result.getMatchingObject()));
        }
        return newResults;
    }
}

