/*
 * Decompiled with CFR 0.152.
 */
package net.byteseek.searcher.multisequence.wu_manber;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import net.byteseek.io.reader.WindowReader;
import net.byteseek.io.reader.windows.Window;
import net.byteseek.matcher.multisequence.MultiSequenceMatcher;
import net.byteseek.matcher.sequence.SequenceMatcher;
import net.byteseek.searcher.SearchResult;
import net.byteseek.searcher.SearchUtils;
import net.byteseek.searcher.multisequence.wu_manber.AbstractWuManberSearcher;

public class WuManberTwoByteSearcher
extends AbstractWuManberSearcher {
    public WuManberTwoByteSearcher(MultiSequenceMatcher matcher) {
        super(matcher, 2);
        if (matcher.getMinimumLength() < 2) {
            throw new IllegalArgumentException("A minimum sequence length of at least two is required.");
        }
    }

    @Override
    protected List<SearchResult<SequenceMatcher>> doSearchForwards(WindowReader reader, long fromPosition, long toPosition) throws IOException {
        Window window;
        int arrayStartPosition;
        int arraySearchPosition;
        AbstractWuManberSearcher.SearchInfo info = (AbstractWuManberSearcher.SearchInfo)this.forwardInfo.get();
        int[] safeShifts = info.shifts;
        MultiSequenceMatcher backMatcher = info.matcher;
        int hashBitMask = safeShifts.length - 1;
        long finalPosition = toPosition + (long)this.sequences.getMaximumLength() - 1L;
        for (long searchPosition = fromPosition + (long)this.sequences.getMinimumLength() - 1L; searchPosition <= finalPosition && (window = reader.getWindow(searchPosition)) != null; searchPosition += (long)(arraySearchPosition - arrayStartPosition)) {
            byte[] array = window.getArray();
            arrayStartPosition = reader.getWindowOffset(searchPosition);
            int arrayEndPosition = window.length() - 1;
            long distanceToEnd = finalPosition - window.getWindowPosition();
            int lastSearchPosition = distanceToEnd < (long)arrayEndPosition ? (int)distanceToEnd : arrayEndPosition;
            arraySearchPosition = arrayStartPosition;
            if (arraySearchPosition == 0) {
                // empty if block
            }
            int firstBlockByte = reader.readByte(searchPosition - 1L);
            while (arraySearchPosition <= lastSearchPosition) {
                int blockHash;
                int safeShift;
                int lastBlockByte = array[arraySearchPosition] & 0xFF;
                if (firstBlockByte < 0) {
                    firstBlockByte = array[arraySearchPosition - 1] & 0xFF;
                }
                if ((safeShift = safeShifts[(blockHash = (firstBlockByte << 5) - firstBlockByte + lastBlockByte) & hashBitMask]) == 0) {
                    List<SearchResult<SequenceMatcher>> results;
                    long matchEndPosition = searchPosition + (long)arraySearchPosition - (long)arrayStartPosition;
                    Collection<SequenceMatcher> matches = backMatcher.allMatchesBackwards(reader, matchEndPosition);
                    if (!matches.isEmpty() && !(results = SearchUtils.resultsBackFromPosition(matchEndPosition, matches, fromPosition, toPosition)).isEmpty()) {
                        return results;
                    }
                    ++arraySearchPosition;
                    firstBlockByte = lastBlockByte;
                    continue;
                }
                arraySearchPosition += safeShift;
                firstBlockByte = -1;
            }
        }
        return SearchUtils.noResults();
    }

    @Override
    public List<SearchResult<SequenceMatcher>> searchForwards(byte[] bytes, int fromPosition, int toPosition) {
        AbstractWuManberSearcher.SearchInfo info = (AbstractWuManberSearcher.SearchInfo)this.forwardInfo.get();
        int[] safeShifts = info.shifts;
        int hashBitMask = safeShifts.length - 1;
        MultiSequenceMatcher backMatcher = info.matcher;
        int lastPossiblePosition = bytes.length - 1;
        int lastPosition = toPosition < lastPossiblePosition ? toPosition : lastPossiblePosition;
        int lastMinimumPosition = this.sequences.getMinimumLength() - 1;
        int searchPosition = fromPosition > 0 ? fromPosition + lastMinimumPosition : lastMinimumPosition;
        int firstBlockByte = -1;
        while (searchPosition <= lastPosition) {
            int blockHash;
            int safeShift;
            int lastBlockByte = bytes[searchPosition] & 0xFF;
            if (firstBlockByte < 0) {
                firstBlockByte = bytes[searchPosition - 1] & 0xFF;
            }
            if ((safeShift = safeShifts[(blockHash = (firstBlockByte << 5) - firstBlockByte + lastBlockByte) & hashBitMask]) == 0) {
                List<SearchResult<SequenceMatcher>> results;
                Collection<SequenceMatcher> matches = backMatcher.allMatchesBackwards(bytes, searchPosition);
                if (!matches.isEmpty() && !(results = SearchUtils.resultsBackFromPosition(searchPosition, matches, fromPosition, toPosition)).isEmpty()) {
                    return results;
                }
                ++searchPosition;
                firstBlockByte = lastBlockByte;
                continue;
            }
            searchPosition += safeShift;
            firstBlockByte = -1;
        }
        return SearchUtils.noResults();
    }

    @Override
    protected List<SearchResult<SequenceMatcher>> doSearchBackwards(WindowReader reader, long fromPosition, long toPosition) throws IOException {
        Window window;
        int arraySearchPosition;
        int arrayStartPosition;
        AbstractWuManberSearcher.SearchInfo info = (AbstractWuManberSearcher.SearchInfo)this.forwardInfo.get();
        int[] safeShifts = info.shifts;
        MultiSequenceMatcher matcher = info.matcher;
        int hashBitMask = safeShifts.length - 1;
        for (long searchPosition = fromPosition; searchPosition >= toPosition && (window = reader.getWindow(searchPosition)) != null; searchPosition -= (long)(arrayStartPosition - arraySearchPosition)) {
            byte[] array = window.getArray();
            arrayStartPosition = reader.getWindowOffset(searchPosition);
            long distanceToEnd = toPosition - window.getWindowPosition();
            int lastSearchPosition = distanceToEnd > 0L ? (int)distanceToEnd : 0;
            arraySearchPosition = arrayStartPosition;
            int lastBlockByte = reader.readByte(searchPosition + 1L);
            while (arraySearchPosition >= lastSearchPosition) {
                int blockHash;
                int safeShift;
                int firstBlockByte = array[arraySearchPosition] & 0xFF;
                if (lastBlockByte < 0) {
                    lastBlockByte = array[arraySearchPosition + 1];
                }
                if ((safeShift = safeShifts[(blockHash = (firstBlockByte << 5) - firstBlockByte + lastBlockByte) & hashBitMask]) == 0) {
                    List<SearchResult<SequenceMatcher>> results;
                    long startMatchPosition = searchPosition - (long)(arrayStartPosition - arraySearchPosition);
                    Collection<SequenceMatcher> matches = matcher.allMatches(reader, startMatchPosition);
                    if (!matches.isEmpty() && !(results = SearchUtils.resultsAtPosition(startMatchPosition, matches)).isEmpty()) {
                        return results;
                    }
                    --arraySearchPosition;
                    lastBlockByte = firstBlockByte;
                    continue;
                }
                arraySearchPosition -= safeShift;
                lastBlockByte = -1;
            }
        }
        return SearchUtils.noResults();
    }

    @Override
    public List<SearchResult<SequenceMatcher>> searchBackwards(byte[] bytes, int fromPosition, int toPosition) {
        AbstractWuManberSearcher.SearchInfo info = (AbstractWuManberSearcher.SearchInfo)this.backwardInfo.get();
        int[] safeShifts = info.shifts;
        MultiSequenceMatcher verifier = info.matcher;
        int hashBitMask = safeShifts.length - 1;
        int finalPosition = toPosition > 0 ? toPosition : 0;
        int lastPossiblePosition = bytes.length - this.sequences.getMinimumLength();
        int searchPosition = fromPosition < lastPossiblePosition ? fromPosition : lastPossiblePosition;
        int lastBlockByte = -1;
        while (searchPosition >= finalPosition) {
            int blockHash;
            int safeShift;
            int firstBlockByte = bytes[searchPosition] & 0xFF;
            if (lastBlockByte < 0) {
                lastBlockByte = bytes[searchPosition + 1] & 0xFF;
            }
            if ((safeShift = safeShifts[(blockHash = (firstBlockByte << 5) - firstBlockByte + lastBlockByte) & hashBitMask]) == 0) {
                Collection<SequenceMatcher> matches = verifier.allMatches(bytes, searchPosition);
                if (!matches.isEmpty()) {
                    return SearchUtils.resultsAtPosition(searchPosition, matches);
                }
                --searchPosition;
                lastBlockByte = firstBlockByte;
                continue;
            }
            searchPosition -= safeShift;
            lastBlockByte = -1;
        }
        return SearchUtils.noResults();
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[block size: " + this.blockSize + " sequences:" + this.sequences + ']';
    }
}

