/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.common.security;

import com.exlibris.core.infra.common.security.CustomerInstitutionRetriever;
import com.exlibris.core.infra.common.security.UserPrincipal;
import java.security.Principal;
import javax.servlet.http.HttpServletRequest;
import org.springframework.security.authentication.jaas.JaasAuthenticationToken;

public class UserPrincipalRetriever {
    public static final String USER_PRINCIPAL = "USER_PRINCIPAL";
    public static final String IGNORE_REQUEST = "ignoreRequest";

    public static void setUserPrincipal(Principal p) {
        if (p == null) {
            return;
        }
        if (p instanceof UserPrincipal) {
            CustomerInstitutionRetriever.setPrincipal((UserPrincipal)p);
            return;
        }
        if (p instanceof JaasAuthenticationToken) {
            for (Principal principal : ((JaasAuthenticationToken)p).getLoginContext().getSubject().getPrincipals()) {
                if (!(principal instanceof UserPrincipal)) continue;
                CustomerInstitutionRetriever.setPrincipal((UserPrincipal)principal);
            }
        }
    }

    public static UserPrincipal getUserPrincipal() {
        Principal p = null;
        HttpServletRequest httpServletRequest = UserPrincipalRetriever.getHttpRequest();
        if (httpServletRequest != null && httpServletRequest.getUserPrincipal() != null && httpServletRequest.getAttribute(IGNORE_REQUEST) == null) {
            p = httpServletRequest.getUserPrincipal();
        }
        if (p != null) {
            if (p instanceof UserPrincipal) {
                return (UserPrincipal)p;
            }
            if (p instanceof JaasAuthenticationToken) {
                for (Principal principal : ((JaasAuthenticationToken)p).getLoginContext().getSubject().getPrincipals()) {
                    if (!(principal instanceof UserPrincipal)) continue;
                    return (UserPrincipal)principal;
                }
            }
        }
        if ((p = CustomerInstitutionRetriever.getPrincipal()) != null && p instanceof UserPrincipal) {
            return (UserPrincipal)p;
        }
        return null;
    }

    public static void setHttpRequest(HttpServletRequest httpServletRequest) {
        CustomerInstitutionRetriever.setServletRequest(httpServletRequest);
    }

    public static HttpServletRequest getHttpRequest() {
        return CustomerInstitutionRetriever.getServletRequest();
    }

    public static String getInstitutionPath() {
        UserPrincipal principal = UserPrincipalRetriever.getUserPrincipal();
        if (principal != null) {
            return principal.getInstitutionPath();
        }
        return null;
    }

    public static boolean isLoggedIn() {
        return UserPrincipalRetriever.getUserPrincipal() != null;
    }

    public static String getInstitutionPathNoException() {
        String institutionPath;
        try {
            institutionPath = UserPrincipalRetriever.getInstitutionPath();
        }
        catch (Exception e) {
            return null;
        }
        return institutionPath;
    }
}

