/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.common.startup;

import com.exlibris.core.infra.common.util.GeneralServerUtil;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class ServerStartedStatus {
    private static final Logger logger = Logger.getLogger(ServerStartedStatus.class);
    private static ServerStartedStatus instance = new ServerStartedStatus();
    private static Set<String> wars = new HashSet<String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void waitStartup() {
        try {
            ServerStartedStatus serverStartedStatus = instance;
            synchronized (serverStartedStatus) {
                while (!ServerStartedStatus.isStarted()) {
                    instance.wait();
                }
            }
        }
        catch (InterruptedException e) {
            return;
        }
    }

    public static boolean isStarted() {
        return wars.size() == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setStartedTrue(String contextPath) {
        logger.log((Priority)Level.INFO, (Object)(" --------------------------------------- " + contextPath + " created --------------------------------------- "));
        if (wars.contains(contextPath)) {
            wars.remove(contextPath);
        } else {
            logger.log((Priority)Level.INFO, (Object)(contextPath + " not declared ***************************************** "));
        }
        if (ServerStartedStatus.isStarted()) {
            ServerStartedStatus serverStartedStatus = instance;
            synchronized (serverStartedStatus) {
                instance.notifyAll();
                new Thread(new LogFlusher()).start();
            }
        }
    }

    static {
        wars.add("/dpsws");
        wars.add("/last");
        wars.add("/rosetta-console");
        if (GeneralServerUtil.serverHasDelRole()) {
            wars.add("/delivery");
            wars.add("/view");
            wars.add("/image-server");
            wars.add("/flex-paper");
            wars.add("/flex-paper-html5");
            wars.add("/jpeg-viewer");
        }
        if (GeneralServerUtil.serverHasRepRole()) {
            wars.add("/mng");
            wars.add("/webeditor");
            wars.add("/report");
            wars.add("/oaiprovider");
        }
        if (GeneralServerUtil.serverHasDepRole()) {
            wars.add("/deposit");
        }
        if (GeneralServerUtil.serverHasPerRole()) {
            wars.add("/permanent");
        }
        if (GeneralServerUtil.serverHasIdxRole()) {
            wars.add("/solr");
        }
    }

    private static class LogFlusher
    implements Runnable {
        private LogFlusher() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                LogFlusher logFlusher = this;
                synchronized (logFlusher) {
                    Thread.sleep(5000L);
                }
                Enumeration allAppenders = LogManager.getRootLogger().getAllAppenders();
                while (allAppenders.hasMoreElements()) {
                    FileAppender fileAppender;
                    Object nextElement = allAppenders.nextElement();
                    if (!(nextElement instanceof FileAppender) || (fileAppender = (FileAppender)nextElement).getImmediateFlush()) continue;
                    fileAppender.setImmediateFlush(true);
                    logger.info((Object)("the appender " + fileAppender + " was flushed."));
                    fileAppender.setImmediateFlush(false);
                }
            }
            catch (Exception e) {
                logger.error((Object)"error during flushing appender", (Throwable)e);
            }
        }
    }
}

