/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.common.util;

import java.util.HashMap;
import java.util.Map;

public class ParamStringFormatter {
    private static final String DEFAULT_DELIM = "@@";
    private final String startDelim;
    private final String endDelim;

    public ParamStringFormatter(String startDelim, String endDelim) {
        this.startDelim = startDelim;
        this.endDelim = endDelim;
    }

    public ParamStringFormatter(String delim) {
        this(delim, delim);
    }

    public ParamStringFormatter() {
        this(DEFAULT_DELIM, DEFAULT_DELIM);
    }

    public String format(String template, Map<String, String> argsMap) {
        StringBuffer buffer = new StringBuffer(template.length() * 2);
        int appendIndex = 0;
        int paramStartIndex = template.indexOf(this.startDelim);
        int paramEndIndex = template.indexOf(this.endDelim, paramStartIndex + this.startDelim.length());
        while (paramStartIndex > 0 && paramEndIndex > 0) {
            buffer.append(template.substring(appendIndex, paramStartIndex));
            String paramName = template.substring(paramStartIndex + this.startDelim.length(), paramEndIndex);
            String paramValue = argsMap.get(paramName);
            buffer.append(paramValue);
            appendIndex = paramEndIndex + this.endDelim.length();
            paramStartIndex = template.indexOf(this.startDelim, appendIndex);
            paramEndIndex = template.indexOf(this.endDelim, paramStartIndex + this.startDelim.length());
        }
        buffer.append(template.substring(appendIndex));
        return buffer.toString();
    }

    public static void main(String[] args) {
        String template = "This is a message with arguments: @@string@@, @@number@@ and @@symbol@@ (three parameters in total).";
        HashMap<String, String> argsMap = new HashMap<String, String>(3);
        argsMap.put("number", "123");
        argsMap.put("string", "abc");
        argsMap.put("symbol", "$%^");
        System.out.println("Template:\n\t" + template);
        System.out.println("Arguments:\n\t" + argsMap);
        ParamStringFormatter formatter = new ParamStringFormatter();
        String formatted = formatter.format(template, argsMap);
        System.out.println("Formatted:\n\t" + formatted);
    }
}

