/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.entityLock;

import com.exlibris.core.infra.entityLock.LockLifeCycle;
import com.exlibris.core.infra.model.HPersistent;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;

@Entity
@NamedQueries(value={@NamedQuery(name="NumberOfObjectsLockedByUser", query="select count(*) from HDeLock lock where lockType = :lockType and lockId =:lockId")})
@Table(name="HDE_LOCK", uniqueConstraints={@UniqueConstraint(columnNames={"LOCK_ID", "LOCK_TYPE"})})
public class HDeLock
extends HPersistent {
    private static final long serialVersionUID = 1L;
    private String lockId;
    private String lockingAgentId;
    private String lockingAgentFullName;
    private String lockType;
    private String lockingAgentType;
    private LockLifeCycle lifecycle;
    private Date creationDate;
    private Date modificationDate;

    public HDeLock() {
    }

    public HDeLock(String lockType, String lockId, String agentType, String agentId, String agentFullName) {
        this.lockId = lockId;
        this.lockingAgentId = agentId;
        this.lockingAgentFullName = agentFullName;
        this.lockType = lockType;
        this.lockingAgentType = agentType;
        this.lifecycle = LockLifeCycle.Alive;
        this.creationDate = new Date(System.currentTimeMillis());
    }

    @Column(name="LOCK_ID", length=255)
    public String getLockId() {
        return this.lockId;
    }

    @Column(name="LOCKING_AGENT_ID")
    public String getLockingAgentId() {
        return this.lockingAgentId;
    }

    @Column(name="LOCKING_AGENT_FULL_NAME")
    public String getLockingAgentFullName() {
        return this.lockingAgentFullName;
    }

    @Column(name="LOCK_TYPE", length=78)
    public String getLockType() {
        return this.lockType;
    }

    @Enumerated(value=EnumType.STRING)
    @Column(name="LIFE_CYCLE")
    public LockLifeCycle getLifecycle() {
        return this.lifecycle;
    }

    @Column(name="LOCKING_AGENT_TYPE")
    public String getLockingAgentType() {
        return this.lockingAgentType;
    }

    @Column(name="CREATION_DATE")
    public Date getCreationDate() {
        return this.creationDate;
    }

    @Column(name="MODIFICATION_DATE")
    public Date getModificationDate() {
        return this.modificationDate;
    }

    public void setLockId(String lockId) {
        this.lockId = lockId;
    }

    public void setLockingAgentId(String lockingAgentId) {
        this.lockingAgentId = lockingAgentId;
    }

    public void setLockingAgentFullName(String lockingAgentFullName) {
        this.lockingAgentFullName = lockingAgentFullName;
    }

    public void setLockType(String lockType) {
        this.lockType = lockType;
    }

    public void setLifecycle(LockLifeCycle lifecycle) {
        this.lifecycle = lifecycle;
    }

    public void setLockingAgentType(String lockingAgentType) {
        this.lockingAgentType = lockingAgentType;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    public void setModificationDate(Date modificationDate) {
        this.modificationDate = modificationDate;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.creationDate == null ? 0 : this.creationDate.hashCode());
        result = 31 * result + (this.lifecycle == null ? 0 : this.lifecycle.hashCode());
        result = 31 * result + (this.lockId == null ? 0 : this.lockId.hashCode());
        result = 31 * result + (this.lockType == null ? 0 : this.lockType.hashCode());
        result = 31 * result + (this.lockingAgentFullName == null ? 0 : this.lockingAgentFullName.hashCode());
        result = 31 * result + (this.lockingAgentId == null ? 0 : this.lockingAgentId.hashCode());
        result = 31 * result + (this.lockingAgentType == null ? 0 : this.lockingAgentType.hashCode());
        result = 31 * result + (this.modificationDate == null ? 0 : this.modificationDate.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HDeLock other = (HDeLock)obj;
        if (this.creationDate == null ? other.creationDate != null : !this.creationDate.equals(other.creationDate)) {
            return false;
        }
        if (this.lifecycle == null ? other.lifecycle != null : !this.lifecycle.equals((Object)other.lifecycle)) {
            return false;
        }
        if (this.lockId == null ? other.lockId != null : !this.lockId.equals(other.lockId)) {
            return false;
        }
        if (this.lockType == null ? other.lockType != null : !this.lockType.equals(other.lockType)) {
            return false;
        }
        if (this.lockingAgentFullName == null ? other.lockingAgentFullName != null : !this.lockingAgentFullName.equals(other.lockingAgentFullName)) {
            return false;
        }
        if (this.lockingAgentId == null ? other.lockingAgentId != null : !this.lockingAgentId.equals(other.lockingAgentId)) {
            return false;
        }
        if (this.lockingAgentType == null ? other.lockingAgentType != null : !this.lockingAgentType.equals(other.lockingAgentType)) {
            return false;
        }
        return !(this.modificationDate == null ? other.modificationDate != null : !this.modificationDate.equals(other.modificationDate));
    }
}

