/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.svc.api.security;

import java.security.InvalidKeyException;
import java.security.Key;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;

public class SecurityHash {
    private static SecurityHash theOnlyOne = null;
    private static Map secure = null;
    private static Key key = null;
    private static Cipher cipher = null;
    private static String algorithm = "DESede";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static SecurityHash getInstance() {
        if (theOnlyOne == null) {
            Class<SecurityHash> clazz = SecurityHash.class;
            // MONITORENTER : com.exlibris.core.infra.svc.api.security.SecurityHash.class
            if (theOnlyOne == null) {
                theOnlyOne = new SecurityHash();
            }
            // MONITOREXIT : clazz
        }
        if (secure != null) return theOnlyOne;
        secure = new HashMap();
        try {
            SecurityHash.setUp();
            return theOnlyOne;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return theOnlyOne;
    }

    public Map getMap() {
        return secure;
    }

    public void add(String key, String value) {
        if (secure.get(key) == null) {
            try {
                secure.put(key, new String(SecurityHash.encrypt(value), "ISO-8859-1"));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void remove(String key) {
        if (secure.get(key) == null) {
            return;
        }
        secure.remove(key);
    }

    public String get(String key) {
        if (secure == null) {
            return null;
        }
        try {
            String value = (String)secure.get(key);
            byte[] byteValue = value.getBytes("ISO-8859-1");
            return SecurityHash.decrypt(byteValue);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static void setUp() throws Exception {
        key = KeyGenerator.getInstance(algorithm).generateKey();
        cipher = Cipher.getInstance(algorithm);
    }

    private static byte[] encrypt(String input) throws InvalidKeyException, BadPaddingException, IllegalBlockSizeException {
        cipher.init(1, key);
        byte[] inputBytes = input.getBytes();
        return cipher.doFinal(inputBytes);
    }

    private static String decrypt(byte[] encryptionBytes) throws InvalidKeyException, BadPaddingException, IllegalBlockSizeException {
        cipher.init(2, key);
        byte[] recoveredBytes = cipher.doFinal(encryptionBytes);
        String recovered = new String(recoveredBytes);
        return recovered;
    }
}

