/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.svc.api.security;

import com.exlibris.core.infra.svc.api.sharedsession.SessionHelper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.security.Principal;
import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.context.HttpRequestResponseHolder;
import org.springframework.security.web.context.SecurityContextRepository;

public class SharedSessionSecurityContextRepository
implements SecurityContextRepository {
    public static final String LOGIN_SECURITY_CONTEXT = "LOGIN_SECURITY_CONTEXT";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object copy(Serializable serializable) {
        Class<SharedSessionSecurityContextRepository> clazz = SharedSessionSecurityContextRepository.class;
        synchronized (SharedSessionSecurityContextRepository.class) {
            Object e1;
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream out = null;
            try {
                out = new ObjectOutputStream(bos);
                out.writeObject(serializable);
            }
            catch (Exception e12) {
            }
            finally {
                try {
                    out.close();
                    bos.close();
                }
                catch (IOException e12) {
                    e12.printStackTrace();
                }
            }
            ByteArrayInputStream bis = new ByteArrayInputStream(bos.toByteArray());
            ObjectInputStream in = null;
            try {
                in = new ObjectInputStream(bis);
                e1 = in.readObject();
            }
            catch (Exception e2) {
                e2.printStackTrace();
                Object var8_15 = null;
                // ** MonitorExit[clazz] (shouldn't be in output)
                return var8_15;
            }
            return e1;
            finally {
                try {
                    bis.close();
                    in.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public SecurityContext loadContext(HttpRequestResponseHolder requestResponseHolder) {
        SecurityContext context;
        block7: {
            context = null;
            Serializable serializable = (Serializable)SessionHelper.getAttribute(requestResponseHolder.getRequest(), LOGIN_SECURITY_CONTEXT);
            try {
                context = (SecurityContext)serializable;
            }
            catch (ClassCastException e) {
                if (serializable == null) break block7;
                HttpSession session = requestResponseHolder.getRequest().getSession();
                context = (SecurityContext)session.getAttribute(LOGIN_SECURITY_CONTEXT);
                context = (SecurityContext)this.copy(serializable);
                try {
                    Method getAuthentication = serializable.getClass().getDeclaredMethod("getAuthentication", new Class[0]);
                    Object auth = getAuthentication.invoke((Object)serializable, new Object[0]);
                    Method getLoginContext = auth.getClass().getDeclaredMethod("getLoginContext", new Class[0]);
                    Object loginContext = getLoginContext.invoke(auth, new Object[0]);
                    if (loginContext != null) {
                        Method getSubject = loginContext.getClass().getDeclaredMethod("getSubject", new Class[0]);
                        Object subject = getSubject.invoke(loginContext, new Object[0]);
                        Method getPrincipals = subject.getClass().getDeclaredMethod("getPrincipals", new Class[0]);
                        Collection principals = (Collection)getPrincipals.invoke(subject, new Object[0]);
                        for (Principal principal : principals) {
                            if (!principal.getClass().getName().contains("UserPrincipal")) continue;
                            session.setAttribute("USER_PRINCIPAL", this.copy((Serializable)((Object)principal)));
                        }
                    }
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        }
        if (context == null) {
            context = SecurityContextHolder.createEmptyContext();
        }
        return context;
    }

    public void saveContext(SecurityContext context, HttpServletRequest request, HttpServletResponse response) {
        HttpSession session = request.getSession(false);
        if (session == null || session.getAttribute("USER_PRINCIPAL") == null) {
            SessionHelper.setAttribute(request, LOGIN_SECURITY_CONTEXT, context);
        }
    }

    public boolean containsContext(HttpServletRequest request) {
        return SessionHelper.getAttribute(request, LOGIN_SECURITY_CONTEXT) != null;
    }
}

