/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.digitool.fsutils;

import com.exlibris.core.infra.common.exceptions.logging.DescriptorConstants;
import com.exlibris.core.infra.common.util.IOUtil;
import com.exlibris.core.sdk.utils.FSUtil;
import com.exlibris.core.sdk.utils.FileUtil;
import com.exlibris.digitool.exceptions.DigitoolException;
import com.exlibris.digitool.fsutils.FileComparator;
import com.exlibris.digitool.fsutils.XmlFileFilter;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;

public class FSFolderUtil {
    public static final String FILES_DIR = "streams";
    public static final String DIGITAL_ENTITY_DIR = "digital_entities";
    private static final String LOG_DIR = "logs";
    protected static final String DIGITAL_ENTITY_TEMPLATE = "DigitalEntityTemplate.xml";
    public static final String METS_ZIP = "mets.zip";
    public static final String METS_XML = "mets.xml";
    public static final String MARC_XML = "marc.xml";
    public static final String MODS_XML = "mods.xml";
    public static final String DC_XML = "dc.xml";
    private static final String STATUS_FILE = "status.txt";
    public static final String INGEST_SETTINGS_FILE = "ingest_settings.xml";
    private static final String MD_DIR = "md/";
    private String m_folderId = null;
    protected String m_folderDir = null;
    protected String m_filesDir = null;
    protected String m_digitalEntitiesDir = null;
    protected String m_logDir = null;
    private StringBuffer m_buffer = null;
    private BufferedOutputStream m_buffOutStream = null;

    protected FSFolderUtil(String folderDir, String folderId) {
        this.m_folderId = folderId;
        this.m_buffer = new StringBuffer(100);
        this.m_folderDir = this.m_buffer.append(folderDir).append(this.getFolderPrefix()).append(this.m_folderId).append(FSUtil.SEPARATOR).toString();
        this.m_filesDir = this.m_folderDir + FILES_DIR + FSUtil.SEPARATOR;
        this.m_digitalEntitiesDir = this.m_folderDir + DIGITAL_ENTITY_DIR + FSUtil.SEPARATOR;
        this.m_logDir = this.m_folderDir + LOG_DIR + FSUtil.SEPARATOR;
    }

    String getFolderPrefix() {
        return "folder_";
    }

    public boolean createNewDirStructure() {
        FileUtil.createFile(this.m_folderDir);
        FileUtil.createFile(this.m_filesDir);
        FileUtil.createFile(this.m_logDir);
        FileUtil.createFile(this.m_digitalEntitiesDir);
        return true;
    }

    public boolean isExists() {
        File f = new File(this.m_folderDir);
        return f.exists();
    }

    public void deleteDirStructure() throws IOException {
        FileUtil.forceDelete(this.m_folderDir);
    }

    public void resetDirStructure() throws IOException {
        this.deleteDirStructure();
        this.createNewDirStructure();
    }

    public boolean addFile(String sourcePath) throws IOException {
        if (this.m_filesDir == null) {
            return false;
        }
        FileUtil.copyFileToDirectory(sourcePath, this.m_filesDir);
        return true;
    }

    public boolean addFile(File sourcePath) throws IOException {
        if (this.m_filesDir == null) {
            return false;
        }
        FileUtil.copyFileToDirectory(sourcePath, new File(this.m_filesDir));
        return true;
    }

    public boolean addDigitalEntity(File sourcePath) throws IOException {
        if (this.m_filesDir == null) {
            return false;
        }
        FileUtil.copyFileToDirectory(sourcePath, new File(this.m_digitalEntitiesDir));
        return true;
    }

    public boolean addFile(InputStream source, String fileName) throws IOException {
        if (this.m_filesDir == null) {
            return false;
        }
        this.m_buffOutStream = new BufferedOutputStream(new FileOutputStream(this.m_filesDir + fileName));
        IOUtil.copy(source, (OutputStream)this.m_buffOutStream);
        this.m_buffOutStream.close();
        source.close();
        return true;
    }

    public boolean deleteDigitalEntity(String fileName) {
        if (this.m_filesDir == null) {
            return false;
        }
        new File(this.m_digitalEntitiesDir + fileName).delete();
        return true;
    }

    public boolean addFile(String fileContents, String fileNameWithExt) throws IOException {
        if (this.m_filesDir == null) {
            return false;
        }
        this.m_buffOutStream = new BufferedOutputStream(new FileOutputStream(this.m_filesDir + fileNameWithExt));
        IOUtil.copy(fileContents, (OutputStream)this.m_buffOutStream);
        this.m_buffOutStream.close();
        return true;
    }

    public boolean addFiles(String[] files) throws IOException {
        if (this.m_filesDir == null) {
            return false;
        }
        for (int i = 0; i < files.length; ++i) {
            FileUtil.copyFile(files[i], this.m_filesDir);
        }
        return true;
    }

    public boolean addFiles(List files) throws IOException {
        if (this.m_filesDir == null) {
            return false;
        }
        int size = files.size();
        for (int i = 0; i < size; ++i) {
            FileUtil.copyFile((String)files.get(i), this.m_filesDir);
        }
        return true;
    }

    public boolean removeAllFiles() throws IOException {
        if (this.m_filesDir == null) {
            return false;
        }
        FileUtil.cleanDirectory(this.m_filesDir);
        return true;
    }

    public boolean removeFile(String fileName) throws IOException {
        if (this.m_filesDir == null) {
            return false;
        }
        String lFile = this.m_filesDir + fileName;
        if (!new File(lFile).isFile()) {
            return false;
        }
        FileUtil.forceDelete(lFile);
        return true;
    }

    public File[] getAllFiles() {
        if (this.m_filesDir == null) {
            return null;
        }
        return new File(this.m_filesDir).listFiles(new FileUtil.FilesFilter());
    }

    public long getFilesSize() {
        File[] files = this.getAllFiles();
        long usage = 0L;
        for (int i = 0; i < files.length; ++i) {
            usage += files[i].length();
        }
        return usage;
    }

    public File[] getAllDigitalEntities() {
        if (this.m_digitalEntitiesDir == null) {
            return null;
        }
        return new File(this.m_digitalEntitiesDir).listFiles(new XmlFileFilter());
    }

    public File[] getAllDigitalEntitiesSorted() {
        File[] files = this.getAllDigitalEntities();
        if (files == null) {
            return null;
        }
        Arrays.sort(files, new FileComparator());
        return files;
    }

    public File getFile(String name) {
        if (this.m_filesDir == null) {
            return null;
        }
        return new File(this.m_filesDir + name);
    }

    public File getDeFile(String name) {
        if (this.m_digitalEntitiesDir == null) {
            return null;
        }
        return new File(this.m_digitalEntitiesDir + name);
    }

    public String getStreamsDir() {
        return this.m_filesDir;
    }

    public String getFolderDir() {
        return this.m_folderDir;
    }

    public String getDigitalEntityDir() {
        return this.m_digitalEntitiesDir;
    }

    public void addUrlFile(String fileName, byte[] content) throws DigitoolException {
        try {
            BufferedOutputStream bis = new BufferedOutputStream(new FileOutputStream(new File(this.m_filesDir + fileName)));
            IOUtil.copy(content, (OutputStream)bis);
            bis.close();
        }
        catch (IOException fo) {
            throw new DigitoolException(DescriptorConstants.GN_FailedToWriteFile, fo.getMessage());
        }
    }

    public void addUrlToExistingUrlFile(String fileName, String content) throws DigitoolException {
        try {
            new File(this.m_filesDir + fileName).createNewFile();
            BufferedWriter out = new BufferedWriter(new FileWriter(this.m_filesDir + fileName, true));
            out.write(content);
            out.close();
        }
        catch (IOException fo) {
            throw new DigitoolException(DescriptorConstants.GN_FailedToWriteFile, fo.getMessage());
        }
    }

    public File getStatusFile() throws DigitoolException {
        File status;
        File logDir = new File(this.m_logDir);
        if (!logDir.exists()) {
            logDir.mkdirs();
        }
        if (!(status = new File(this.m_logDir + STATUS_FILE)).exists()) {
            try {
                status.createNewFile();
            }
            catch (IOException e) {
                throw new DigitoolException(DescriptorConstants.GN_Exception, (Object)e.getMessage(), e.getCause());
            }
        }
        return status;
    }
}

