/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.container;

import java.util.Comparator;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import uk.gov.nationalarchives.droid.container.BinarySignatureXMLParser;
import uk.gov.nationalarchives.droid.container.XmlFragment;
import uk.gov.nationalarchives.droid.core.SignatureParseException;
import uk.gov.nationalarchives.droid.core.signature.droid6.InternalSignatureCollection;
import uk.gov.nationalarchives.droid.core.signature.droid6.InternalSignatureComparator;

@XmlAccessorType(value=XmlAccessType.NONE)
public class ContainerFile {
    @XmlTransient
    private Logger log = LoggerFactory.getLogger(this.getClass());
    @XmlTransient
    private boolean compileError;
    @XmlElement(name="Path")
    private String path;
    @XmlElement(name="BinarySignatures")
    private XmlFragment binarySignatures;
    @XmlTransient
    private InternalSignatureCollection signatures;

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setBinarySignatures(InternalSignatureCollection binarySigs) {
        this.signatures = binarySigs;
    }

    public XmlFragment getBinarySignature() {
        return this.binarySignatures;
    }

    public InternalSignatureCollection getCompiledBinarySignatures() {
        if (this.signatures == null && this.binarySignatures != null && !this.compileError) {
            BinarySignatureXMLParser signatureParser = new BinarySignatureXMLParser();
            Element element = this.binarySignatures.getElement();
            try {
                InternalSignatureCollection signaturesCollection = (InternalSignatureCollection)signatureParser.fromXmlElement(element);
                signaturesCollection.prepareForUse();
                signaturesCollection.sortSignatures((Comparator)new InternalSignatureComparator());
                this.signatures = signaturesCollection;
            }
            catch (SignatureParseException e) {
                this.compileError = true;
                this.signatures = null;
                String message = String.format("Could not parse signature:\n%s", element.getTextContent());
                this.log.warn(message);
            }
        }
        return this.signatures;
    }
}

