/*
 * Decompiled with CFR 0.152.
 */
package gov.loc.repository.bagit.domain;

import java.net.URL;
import java.nio.file.Path;
import java.util.Objects;

public final class FetchItem {
    public final URL url;
    public final Long length;
    public final Path path;
    private transient String cachedString;

    public FetchItem(URL url, Long length, Path path) {
        this.url = url;
        this.length = length;
        this.path = path;
    }

    private String internalToString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.url).append(' ');
        if (this.length == null || this.length < 0L) {
            sb.append("- ");
        } else {
            sb.append(this.length).append(' ');
        }
        sb.append(this.path);
        return sb.toString();
    }

    public String toString() {
        if (this.cachedString == null) {
            this.cachedString = this.internalToString();
        }
        return this.cachedString;
    }

    public URL getUrl() {
        return this.url;
    }

    public Long getLength() {
        return this.length;
    }

    public Path getPath() {
        return this.path;
    }

    public int hashCode() {
        return Objects.hash(this.url) + Objects.hash(this.length) + Objects.hash(this.path);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FetchItem)) {
            return false;
        }
        FetchItem other = (FetchItem)obj;
        return Objects.equals(this.url, other.getUrl()) && Objects.equals(this.length, other.getLength()) && Objects.equals(this.path, other.getPath());
    }
}

