/*
 * Decompiled with CFR 0.152.
 */
package gov.loc.repository.bagit.domain;

import gov.loc.repository.bagit.hash.SupportedAlgorithm;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public final class Manifest {
    private final SupportedAlgorithm algorithm;
    private Map<Path, String> fileToChecksumMap = new HashMap<Path, String>();

    public Manifest(SupportedAlgorithm algorithm) {
        this.algorithm = algorithm;
    }

    public Map<Path, String> getFileToChecksumMap() {
        return this.fileToChecksumMap;
    }

    public void setFileToChecksumMap(Map<Path, String> fileToChecksumMap) {
        this.fileToChecksumMap = fileToChecksumMap;
    }

    public SupportedAlgorithm getAlgorithm() {
        return this.algorithm;
    }

    public String toString() {
        return "Manifest [algorithm=" + this.algorithm + ", fileToChecksumMap=" + this.fileToChecksumMap + "]";
    }

    public int hashCode() {
        return Objects.hash(this.algorithm) + this.fileToChecksumMap.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Manifest)) {
            return false;
        }
        Manifest other = (Manifest)obj;
        return Objects.equals(this.algorithm, other.algorithm) && this.fileToChecksumMap.equals(other.getFileToChecksumMap());
    }
}

