/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.model.consortium;

import com.exlibris.core.infra.model.consortium.HFrHierarchyEntity;
import com.exlibris.core.infra.model.consortium.HFrInstitution;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import org.hibernate.annotations.Cascade;

@Entity
@NamedQueries(value={@NamedQuery(name="findConsortiumByPath", query="from HFrConsortium cons where cons.path = :path")})
@Table(name="HFrConsortium", uniqueConstraints={@UniqueConstraint(columnNames={"PATH", "CODE"})})
public class HFrConsortium
extends HFrHierarchyEntity {
    private List<HFrInstitution> institutions;

    public HFrConsortium(String code, String path) {
        super(code, path);
    }

    public HFrConsortium(String code, String path, String desc) {
        super(code, path, desc);
    }

    public HFrConsortium() {
    }

    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL})
    @JoinColumn(name="consortium_id", updatable=false)
    public List<HFrInstitution> getInstitutions() {
        return this.institutions;
    }

    public void setInstitutions(List<HFrInstitution> institutions) {
        this.institutions = institutions;
    }

    public void addInstitution(HFrInstitution frInstitution) {
        if (this.getInstitutions() == null) {
            this.setInstitutions(new ArrayList<HFrInstitution>());
        }
        frInstitution.setConsortium(this);
        this.getInstitutions().add(frInstitution);
    }
}

