/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.svc.api.config;

import com.exlibris.core.infra.common.exceptions.logging.ExLogger;
import com.exlibris.core.infra.common.util.IOUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.tools.ant.types.FilterSet;

public class GlobalProperties {
    private static GlobalProperties globalProperties = null;
    private final Properties properties = new Properties();
    private static final String globalPropertiesFile = "global.properties";
    private static final String token = "@";
    private FilterSet filterSet;
    private static ExLogger log = ExLogger.getExLogger(GlobalProperties.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GlobalProperties() {
        InputStream in = this.getClass().getClassLoader().getResourceAsStream(globalPropertiesFile);
        if (in != null) {
            try {
                this.properties.load(in);
                this.filterSet = new FilterSet();
                for (Object key : this.properties.keySet()) {
                    this.filterSet.addFilter((String)key, this.properties.getProperty((String)key));
                }
                this.filterSet.setBeginToken(token);
                this.filterSet.setEndToken(token);
            }
            catch (IOException e) {
                log.error("Error reading global.properties file - " + e.getMessage(), new String[0]);
                e.printStackTrace();
            }
            finally {
                IOUtil.closeQuietly(in);
            }
        } else {
            log.skipFormatting();
            log.error("Error reading global.properties file", new String[0]);
        }
    }

    public static synchronized GlobalProperties getInstance() {
        if (globalProperties == null) {
            globalProperties = new GlobalProperties();
        }
        return globalProperties;
    }

    public String setGlobals(String parameter) {
        return this.filterSet.replaceTokens(parameter);
    }

    public String getProperty(String name) {
        return (String)this.properties.get(name);
    }

    public String setPropertyCache(String name, String val) {
        return (String)this.properties.setProperty(name, val);
    }
}

