/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.sdk.storage.policy;

import com.exlibris.core.infra.common.exceptions.logging.ExLogger;
import com.exlibris.core.infra.model.storage.Storage;
import com.exlibris.core.infra.model.storage.StorageCapacity;
import com.exlibris.core.infra.svc.api.locator.ServiceLocator;
import com.exlibris.core.infra.svc.api.services.storage.StorageService;
import com.exlibris.core.sdk.storage.containers.StoredEntityMetaData;
import com.exlibris.core.sdk.storage.policy.StoragePolicy;
import java.util.List;
import java.util.Map;

public abstract class AbstractStoragePolicyFS
implements StoragePolicy {
    private static final String BLOCK_SIZE_XML_NAME = "BLOCK_SIZE";
    private static final String TOTAL_SIZE_XML_NAME = "MAX_SIZE_IN_MB";
    ExLogger logger = ExLogger.getExLogger(AbstractStoragePolicyFS.class);
    private StorageService storageService;

    @Override
    public abstract Storage selectStorage(List<Storage> var1, StoredEntityMetaData var2);

    protected StorageService getStorageService() {
        if (this.storageService == null) {
            this.storageService = (StorageService)ServiceLocator.getInstance().lookUp(StorageService.class);
        }
        return this.storageService;
    }

    protected Long getRealFileSize(Storage storage, Long fileSizeInBytes) {
        Map<String, String> params = storage.getStorageParamAsMap();
        Long blockSize = Long.parseLong(params.get(BLOCK_SIZE_XML_NAME));
        if (fileSizeInBytes % blockSize != 0L) {
            fileSizeInBytes = fileSizeInBytes + (blockSize - fileSizeInBytes % blockSize);
        }
        return fileSizeInBytes;
    }

    protected StorageCapacity createNewCapacity(Storage storage) {
        StorageCapacity storageCapacity = new StorageCapacity();
        storageCapacity.setStorageId(storage.getId());
        storageCapacity.setCapacity(0L);
        try {
            this.getStorageService().saveCapacity(storageCapacity);
        }
        catch (Exception e) {
            this.logger.info("Creation of StorageCapacity Failed - Returning DB One.");
            storageCapacity = this.getStorageService().getStorageCapacity(storage.getId());
        }
        return storageCapacity;
    }

    protected Boolean hasEnoughDiskSpace(StorageCapacity capacity, Storage storage, Long realFileSizeInBytes) {
        Map<String, String> params = storage.getStorageParamAsMap();
        Long totalSizeInBytes = Long.parseLong(params.get(TOTAL_SIZE_XML_NAME)) * 1024L * 1024L;
        if (capacity.getCapacity() + realFileSizeInBytes > totalSizeInBytes) {
            return false;
        }
        return true;
    }

    protected Boolean updateStorageCapacity(Storage storage, StorageCapacity capacity, Long fileSizeInBytes) {
        if (!this.hasEnoughDiskSpace(capacity, storage, fileSizeInBytes = this.getRealFileSize(storage, fileSizeInBytes)).booleanValue()) {
            return false;
        }
        this.getStorageService().updateCapacity(capacity, fileSizeInBytes, true);
        return true;
    }
}

