/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.digitool.config;

import com.exlibris.core.infra.common.exceptions.InfraException;
import com.exlibris.core.infra.common.exceptions.logging.DescriptorConstants;
import com.exlibris.core.infra.common.exceptions.logging.ExLogger;
import com.exlibris.core.infra.model.filetable.HFileTable;
import com.exlibris.core.infra.svc.api.FileTableManager;
import com.exlibris.core.infra.svc.api.locator.ServiceLocator;
import com.exlibris.core.sdk.config.CoreConfigurationManager;
import com.exlibris.core.sdk.utils.FSUtil;
import com.exlibris.digitool.common.pi.PersitenceIdentityPublisher;
import com.exlibris.digitool.common.rule.xmlbeans.DeRuleDocument;
import com.exlibris.digitool.config.ConfigurationJobManager;
import com.exlibris.digitool.config.ConfigurationProfileManager;
import com.exlibris.digitool.config.ConfigurationPublisherManager;
import com.exlibris.digitool.pi.profile.xmlbeans.PiProfile;
import com.exlibris.digitool.pi.profile.xmlbeans.PiProfileRuleDocument;
import com.exlibris.digitool.repository.conf.xmlbeans.DataSource;
import com.exlibris.digitool.repository.conf.xmlbeans.DataSourceParameter;
import com.exlibris.digitool.repository.conf.xmlbeans.DataSourceParameters;
import com.exlibris.digitool.repository.conf.xmlbeans.DataSources;
import com.exlibris.digitool.repository.conf.xmlbeans.DeService;
import com.exlibris.digitool.repository.conf.xmlbeans.DeServices;
import com.exlibris.digitool.repository.conf.xmlbeans.Metadata;
import com.exlibris.digitool.repository.conf.xmlbeans.Metadatas;
import com.exlibris.digitool.repository.conf.xmlbeans.RpConfigurationDocument;
import com.exlibris.digitool.repository.conf.xmlbeans.RpJobsConfigurationDocument;
import com.exlibris.digitool.repository.conf.xmlbeans.SendMessage;
import com.exlibris.digitool.repository.conf.xmlbeans.SendMessages;
import com.exlibris.digitool.repository.conf.xmlbeans.SupportedSchemas;
import com.exlibris.digitool.repository.conf.xmlbeans.Transformer;
import com.exlibris.digitool.repository.conf.xmlbeans.Transformers;
import com.exlibris.digitool.repository.system.RpException;
import com.exlibris.digitool.repository.unitConf.xmlbeans.AccessRight;
import com.exlibris.digitool.repository.unitConf.xmlbeans.AccessRights;
import com.exlibris.digitool.repository.unitConf.xmlbeans.Parameter;
import com.exlibris.digitool.repository.unitConf.xmlbeans.Parameters;
import com.exlibris.digitool.repository.unitConf.xmlbeans.UnitConfigurationDocument;
import com.exlibrisgroup.xsd.digitool.publisher.PiPublisher;
import com.exlibrisgroup.xsd.digitool.publisher.PiPublisherRuleDocument;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class ConfigurationManager
extends CoreConfigurationManager {
    protected static ConfigurationManager rpc;
    protected static final String RP_CONF_FILE = "com.exlibris.dps.repository.configuration";
    protected static final String CONF_FILE_PREFIX = "com.exlibris.dps.repository";
    protected static final String UNITS_CONF_FILE = "unitconfiguration";

    protected ConfigurationManager() {
        this.load();
    }

    public static synchronized ConfigurationManager getInstance() {
        if (rpc == null) {
            rpc = new ConfigurationManager();
        }
        return rpc;
    }

    @Override
    public synchronized void reset() {
        this.isInit = false;
        super.reset();
        this.load();
    }

    public static void main(String[] args) {
        ConfigurationManager.getInstance();
    }

    public DeRuleDocument.DeRule[] getDeRules(String adminUnit) {
        return ConfigurationProfileManager.getInstance().getDeRules(adminUnit);
    }

    public PiProfile[] getPiProfiles(String adminUnit) {
        return ConfigurationProfileManager.getInstance().getPiProfiles(adminUnit);
    }

    public PiProfileRuleDocument getPiProfileRuleDocument(String adminUnit) {
        return ConfigurationProfileManager.getInstance().getPiProfileRuleDocument(adminUnit);
    }

    public DeRuleDocument.DeRule getPublisherDeRule(String adminUnit, String ruleName) {
        return ConfigurationPublisherManager.getInstance().getDeRule(adminUnit, ruleName);
    }

    public PiPublisher getPiPublisher(String adminUnit, String publisherName) {
        return ConfigurationPublisherManager.getInstance().getPiPublisher(adminUnit, publisherName);
    }

    public PersitenceIdentityPublisher getPiPublisherInstance(String adminUnit, String publisherName) {
        return ConfigurationPublisherManager.getInstance().getPiPublisherInstance(adminUnit, publisherName);
    }

    public DeRuleDocument.DeRule[] getPublisherDeRules(String adminUnit) {
        return ConfigurationPublisherManager.getInstance().getDeRules(adminUnit);
    }

    public PiPublisher[] getPiPublishers(String adminUnit) {
        return ConfigurationPublisherManager.getInstance().getPiPublishers(adminUnit);
    }

    public PiPublisherRuleDocument getPiPublisherRuleDocument(String adminUnit) {
        return ConfigurationPublisherManager.getInstance().getPiPublishersRuleDocument(adminUnit);
    }

    public String getPiPublisherProperty(String adminUnit, String key) {
        return ConfigurationPublisherManager.getInstance().getConfigurationProperty(adminUnit, key);
    }

    public Properties getPiPublisherGroupProperty(String adminUnit, String key) {
        return ConfigurationPublisherManager.getInstance().getConfigurationPropertiesGroup(adminUnit, key);
    }

    @Override
    public void hashMds(Metadata[] md) {
        this.name2Metadata.clear();
        this.id2Metadata.clear();
        this.mdType2nsmap.clear();
        for (int i = 0; i < md.length; ++i) {
            this.name2Metadata.put(md[i].getName() + "~" + md[i].getType(), md[i]);
            this.id2Metadata.put(new Integer(md[i].getId()), md[i]);
            SupportedSchemas[] sch = md[i].getSupportedSchemasArray();
            if (sch == null || sch.length <= 0) continue;
            HashMap<String, String> m = null;
            m = new HashMap<String, String>();
            for (int j = 0; j < sch.length; ++j) {
                SupportedSchemas schemas = sch[j];
                m.put(schemas.getNamespaceUri(), schemas.getNamespacePrefix());
            }
            this.mdType2nsmap.put(md[i].getType(), m);
        }
    }

    @Override
    protected void hashMds() {
        Metadatas mds = this.rpcd.getRpConfiguration().getMetadatas();
        if (mds == null) {
            return;
        }
        Metadata[] md = mds.getMetadataArray();
        for (int i = 0; i < md.length; ++i) {
            this.name2Metadata.put(md[i].getName() + "~" + md[i].getType(), md[i]);
            this.id2Metadata.put(new Integer(md[i].getId()), md[i]);
            SupportedSchemas[] sch = md[i].getSupportedSchemasArray();
            if (sch == null || sch.length <= 0) continue;
            HashMap<String, String> m = null;
            m = new HashMap<String, String>();
            for (int j = 0; j < sch.length; ++j) {
                SupportedSchemas schemas = sch[j];
                m.put(schemas.getNamespaceUri(), schemas.getNamespacePrefix());
            }
            this.mdType2nsmap.put(md[i].getType(), m);
        }
    }

    @Override
    public Map getNamespacesByMetadataType(String metadataType) {
        return (Map)this.mdType2nsmap.get(metadataType);
    }

    @Override
    public String getNamespacePrefix(String metadataType, String namespaceUri) {
        return (String)this.getNamespacesByMetadataType(metadataType).get(namespaceUri);
    }

    @Override
    protected void hashTransformers() {
        Transformers transformers = this.rpcd.getRpConfiguration().getTransformers();
        if (transformers == null) {
            return;
        }
        Transformer[] tf = transformers.getTransformerArray();
        for (int i = 0; i < tf.length; ++i) {
            this.transformersHash.put(new Integer(tf[i].getId()), tf[i].copy());
        }
    }

    @Override
    protected void hashDeServices() {
        DeServices deServices = this.rpcd.getRpConfiguration().getDeServices();
        if (deServices == null) {
            return;
        }
        DeService[] des = deServices.getDeServiceArray();
        for (int i = 0; i < des.length; ++i) {
            this.desHash.put(des[i].getName(), des[i].copy());
        }
    }

    @Override
    public DeService[] getDeServices() {
        return this.desHash.values().toArray(new DeService[0]);
    }

    @Override
    protected void hashDataSources() {
        DataSources dataSources = this.rpcd.getRpConfiguration().getDataSources();
        if (dataSources == null) {
            return;
        }
        DataSource[] ds = dataSources.getDataSourceArray();
        for (int i = 0; i < ds.length; ++i) {
            this.dataSourcesHash.put(new Integer(ds[i].getId()), ds[i].copy());
        }
    }

    @Override
    public String getDataSourceParameter(int id, String key) throws Exception {
        boolean cont = true;
        String val = null;
        DataSource ds = this.getDataSource(id);
        DataSourceParameters parameters = ds.getDataSourceParameters();
        if (parameters == null) {
            return null;
        }
        for (int i = 0; i < parameters.sizeOfDataSourceParameterArray() && cont; ++i) {
            DataSourceParameter parameter = parameters.getDataSourceParameterArray(i);
            if (!key.equals(parameter.getName())) continue;
            val = parameter.getStringValue().trim();
            cont = false;
        }
        return val;
    }

    @Override
    public DataSource getDataSource(int id) throws RpException {
        DataSource ds = (DataSource)this.dataSourcesHash.get(new Integer(id));
        if (ds == null) {
            throw new RpException("DataSource not defined in conf.xml: id = " + id);
        }
        return ds;
    }

    @Override
    protected void hashSendMessage() {
        SendMessages sendMessages = this.rpcd.getRpConfiguration().getSendMessages();
        if (sendMessages == null) {
            log.info("Message notification is disabled.");
            return;
        }
        SendMessage[] send = sendMessages.getSendMessageArray();
        for (int i = 0; i < send.length; ++i) {
            log.info(send[i].getType() + " message is enabled.");
            this.sendHash.put(send[i].getType(), send[i].copy());
        }
    }

    @Override
    public SendMessage getSendMessage(String type) {
        return (SendMessage)this.sendHash.get(type);
    }

    protected void hashAccessRights() {
        this.accessRightsHash.clear();
        List unitList = FSUtil.getUnitList();
        Iterator itr = unitList.iterator();
        while (itr.hasNext()) {
            try {
                UnitConfigurationDocument ucd;
                AccessRights ars;
                String uname = (String)itr.next();
                FileTableManager manager = (FileTableManager)ServiceLocator.getInstance().lookUp(FileTableManager.class);
                HFileTable confFile = manager.getFileByKey("com.exlibris.dps.repository." + uname + "." + UNITS_CONF_FILE);
                if (confFile == null || confFile.getFile() == null || (ars = (ucd = UnitConfigurationDocument.Factory.parse(confFile.getFile())).getUnitConfiguration().getAccessRights()) == null) continue;
                AccessRight[] ar = ars.getAccessRightArray();
                for (int i = 0; i < ar.length; ++i) {
                    ar[i].setName(uname + "_" + ar[i].getName());
                    this.accessRightsHash.put(ar[i].getName(), ar[i].copy());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public AccessRight getAccessRight(String name) throws RpException {
        try {
            AccessRight ar = (AccessRight)this.accessRightsHash.get(name);
            if (ar != null) {
                ar = (AccessRight)ar.copy();
            }
            if (ar == null) {
                throw new RpException("AccessRight is not defined in unit_configuration.xml: name=" + name);
            }
            return ar;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    public AccessRight[] getAccessRights(String adminUnit) {
        this.hashAccessRights();
        Iterator itr = this.accessRightsHash.keySet().iterator();
        ArrayList ret = new ArrayList();
        while (itr.hasNext()) {
            String element = (String)itr.next();
            if (adminUnit != null && adminUnit.length() != 0 && (element == null || element.length() <= 0 || !element.startsWith(adminUnit))) continue;
            ret.add(this.accessRightsHash.get(element));
        }
        return ret.toArray(new AccessRight[0]);
    }

    @Override
    protected void load() {
        try {
            log.info("Looking for configuration file: com.exlibris.dps.repository.configuration ...");
            super.load();
            this.hashAccessRights();
            log.info("Setting Loaded");
        }
        catch (Throwable e) {
            log.error("Failed to load configuration from com.exlibris.dps.repository.configuration: " + e.getMessage(), e, new String[0]);
            this.isInit = false;
            throw new RuntimeException("Failed to load configuration from com.exlibris.dps.repository.configuration: " + e.getMessage(), e);
        }
    }

    @Override
    public String getDigitoolHome() {
        String home = System.getProperty("digitool.home");
        if (home == null) {
            return null;
        }
        if (!home.endsWith("/") && !home.endsWith("\\")) {
            home = home + "/";
        }
        home = home + "../";
        return home;
    }

    @Override
    public RpConfigurationDocument getRpConfigurationDocument() {
        return this.rpcd;
    }

    public RpJobsConfigurationDocument getRpJobsConfigurationDocument() {
        return ConfigurationJobManager.getInstance().getRpJobsConfigurationDocument();
    }

    public List getRPJobsClassNameKeyValuePairList() {
        return ConfigurationJobManager.getInstance().getClassNameKeyValuePairList();
    }

    public Map getRPJobsClassNameMap() {
        return ConfigurationJobManager.getInstance().getClassNameMap();
    }

    protected void initLicense() {
        this.setCollMngAllowed(true);
        this.setDepositAllowed(true);
        this.setJpeg2000(true);
        this.setMaxObjectAllowed(1000000);
        log.info("COLLMNG licensed - " + this.isCollMngAllowed());
        log.info("DEPOSIT licensed - " + this.isDepositAllowed());
        log.info("JPEG2000 licensed - " + this.isJpeg2000());
        log.info("MAX-OBJECT-COUNT licensed - " + this.getMaxObjectAllowed());
    }

    @Override
    public boolean isCollMngAllowed() {
        if (this.isDevelopmentMode()) {
            return true;
        }
        return this.isCollMngAllowed;
    }

    @Override
    public void setCollMngAllowed(boolean isCollMngAllowed) {
        this.isCollMngAllowed = isCollMngAllowed;
    }

    @Override
    public boolean isDepositAllowed() {
        if (this.isDevelopmentMode()) {
            return true;
        }
        return this.isDepositAllowed;
    }

    @Override
    public void setDepositAllowed(boolean isDepositAllowed) {
        this.isDepositAllowed = isDepositAllowed;
    }

    @Override
    public boolean isMaxObjectsExceeded() {
        if (this.isDevelopmentMode()) {
            return false;
        }
        return this.getMaxObjectAllowed() - this.getRepositoryObjectCount() < 0;
    }

    @Override
    public int getMaxObjectAllowed() {
        return this.maxObjectAllowed;
    }

    @Override
    public void setMaxObjectAllowed(int maxObjectAllowed) {
        this.maxObjectAllowed = maxObjectAllowed;
    }

    @Override
    public int getRepositoryObjectCount() {
        return this.repositoryObjectCount;
    }

    @Override
    public void setRepositoryObjectCount(int repositoryObjectCount) {
        this.repositoryObjectCount = repositoryObjectCount;
    }

    @Override
    public boolean isJpeg2000() {
        return this.isJpeg2000;
    }

    @Override
    public void setJpeg2000(boolean isJpeg2000) {
        this.isJpeg2000 = isJpeg2000;
    }

    @Override
    public boolean isObjectCacheMode() {
        return this.useObjectCache;
    }

    @Override
    public void setObjectCacheMode(boolean useObjectCache) {
        this.useObjectCache = useObjectCache;
    }

    @Override
    public UnitConfigurationDocument getUnitConfigurationDocument(String adminUnit) {
        return (UnitConfigurationDocument)this.unitConfigurationHash.get(adminUnit);
    }

    @Override
    public Parameter[] getUnitConfigurationParameters(String adminUnit) {
        Parameters unitParameters = null;
        UnitConfigurationDocument unitConfigurationDocument = this.getUnitConfigurationDocument(adminUnit);
        if (unitConfigurationDocument == null || unitConfigurationDocument.getUnitConfiguration() == null) {
            return null;
        }
        unitParameters = unitConfigurationDocument.getUnitConfiguration().getParameters();
        if (unitParameters == null || unitParameters.getParameterArray() == null) {
            return null;
        }
        return unitParameters.getParameterArray();
    }

    @Override
    public List getUnitConfigurationPublicDirectories(String adminUnit) {
        ArrayList<String> toReturn = new ArrayList<String>();
        String noAvailableDirectories = null;
        try {
            noAvailableDirectories = ExLogger.getMessageFromRB(DescriptorConstants.IG_NoAvailableDirectories.getId());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (noAvailableDirectories == null) {
            noAvailableDirectories = "No Available Directories...";
        }
        toReturn.add(noAvailableDirectories);
        Parameter[] parameters = this.getUnitConfigurationParameters(adminUnit);
        if (parameters == null) {
            return toReturn;
        }
        for (int i = 0; i < parameters.length; ++i) {
            String value;
            if (!"acquire_files_directory".equals(parameters[i].getKey()) || (value = parameters[i].getValue()) == null || (value = value.trim()).length() == 0) continue;
            toReturn.remove(noAvailableDirectories);
            toReturn.add(value + File.separator);
        }
        return toReturn;
    }

    @Override
    protected Object parseXmlBean(String className, InputStream xmlStream) {
        try {
            Class<?> beanClass = Class.forName(className);
            Class<?>[] classArray = beanClass.getClasses();
            Class<?> factoryClass = null;
            Object xmlBean = null;
            for (int i = 0; i < classArray.length && factoryClass == null; ++i) {
                Class<?> currClass = classArray[i];
                if (!currClass.getSimpleName().equals("Factory")) continue;
                factoryClass = currClass;
            }
            if (factoryClass != null) {
                Method parseMethod = factoryClass.getDeclaredMethod("parse", InputStream.class);
                xmlBean = parseMethod.invoke(null, xmlStream);
            }
            return xmlBean;
        }
        catch (Exception e) {
            log.error("Can't parse XML Bean: " + e.toString(), e, new String[0]);
            return null;
        }
    }

    public long getParameterAsLong(String module, String key, long defaultValue) throws InfraException {
        String stringVal = this.getParameter(module, key);
        if (stringVal == null) {
            log.warn((Object)("" + module + ":" + key + " is missing from generalParamerter. Default value " + defaultValue + " is used"), new String[0]);
            return defaultValue;
        }
        long longVal = defaultValue;
        try {
            longVal = Long.parseLong(stringVal);
        }
        catch (Exception e) {
            log.error("Failed to parse value of " + module + ":" + key + " (" + stringVal + "). Default value " + defaultValue + " is used", new String[0]);
        }
        return longVal;
    }
}

