/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.digitool.fsutils;

import com.exlibris.digitool.fsutils.FSFolderUtil;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;

public class FSTransformUtil
extends FSFolderUtil {
    public FSTransformUtil(String folderDir, String folderId) {
        super(folderDir, folderId);
    }

    @Override
    String getFolderPrefix() {
        return "transform";
    }

    public String getDigitalEntityTemplateFileName() {
        return this.m_digitalEntitiesDir + "DigitalEntityTemplate.xml";
    }

    public String getMetsZipFileName() {
        return this.m_folderDir + "mets.zip";
    }

    public String getMetsXmlFileName() {
        return this.m_folderDir + "mets.xml";
    }

    public boolean putMetsJar(InputStream isMets) throws IOException {
        return this.addFile(isMets, "../mets.zip");
    }

    public boolean putMetsXml(InputStream isMets) throws IOException {
        return this.addFile(isMets, "../mets.xml");
    }

    public String getMarcXmlFileName() {
        return this.m_folderDir + "marc.xml";
    }

    public File[] getMarcXMLFiles() {
        File f = new File(this.m_folderDir);
        return f.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return (name = name.toLowerCase()).indexOf("marc") != -1;
            }
        });
    }

    public String getModsXmlFileName() {
        return this.m_folderDir + "mods.xml";
    }

    public File[] getModsXMLFiles() {
        File f = new File(this.m_folderDir);
        return f.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return (name = name.toLowerCase()).indexOf("mods") != -1;
            }
        });
    }

    public String getDCXmlFileName() {
        return this.m_folderDir + "dc.xml";
    }

    public File[] getDCXMLFiles() {
        File f = new File(this.m_folderDir);
        return f.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return (name = name.toLowerCase()).indexOf("dc") != -1;
            }
        });
    }

    public String getTransformerFile(String filename) {
        return this.m_folderDir + filename;
    }

    public boolean transformerFileParamExists(String filename) {
        if (filename == null || filename.equals("")) {
            return false;
        }
        return new File(this.m_folderDir + filename).exists();
    }

    public boolean transformerComboParamExists() {
        return new File(this.m_digitalEntitiesDir + "DigitalEntityTemplate.xml").exists();
    }
}

