/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.digitool.infrastructure.utils;

import java.io.BufferedReader;
import java.io.FileReader;

public class MarcCode2NameMapper {
    private static final String INPUT_MAPPING_FILE = "/exlibris/dtl/d3_1/dtl01/md/descriptive/marc/codes.eng";
    public static final String MARC_CODE_PREFIX = "marcCode.";
    public static final String DUBLIN_CODE_PREFIX = "dublinCode.";
    public static final String MODS_PREFIX = "mods.";
    private static final String COMMENT_SIGN = "!";
    private static final int CODE_START_POS = 0;
    private static final int CODE_END_POS = 3;
    private static final int NAME_START_POS = 14;
    private static final int NAME_END_POS = 30;

    public static void main(String[] args) {
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(INPUT_MAPPING_FILE));
            String line = null;
            while ((line = bufferedReader.readLine()) != null) {
                if (line.length() <= 14 || line.trim().startsWith(COMMENT_SIGN)) continue;
                String code = line.substring(0, 3).trim();
                String name = line.substring(14, 30).trim();
                if (code.length() == 0 || name.length() == 0) continue;
                System.out.println(MARC_CODE_PREFIX + code + " = " + name);
            }
        }
        catch (Throwable t) {
            System.out.print(t.getClass().getName() + " :: " + t.getMessage());
            t.printStackTrace();
        }
    }
}

