/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.digitool.utils;

import com.exlibris.core.infra.common.exceptions.logging.DescriptorConstants;
import com.exlibris.core.infra.common.util.ResourceBundleUtil;
import com.exlibris.core.infra.common.util.SynchronizedDateFormat;
import com.exlibris.core.infra.model.progressBar.ProgressBar;
import com.exlibris.core.infra.svc.api.CodeTablesResourceBundle;
import com.exlibris.core.infra.svc.api.locator.ServiceLocator;
import com.exlibris.core.infra.svc.api.progressBar.ProgressBarService;
import com.exlibris.digitool.exceptions.DigitoolException;
import com.exlibris.digitool.utils.JxlColumnStructure;
import com.exlibris.digitool.utils.JxlSheetStructure;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import jxl.Cell;
import jxl.CellType;
import jxl.DateCell;
import jxl.Sheet;
import jxl.Workbook;
import jxl.format.CellFormat;
import jxl.format.Colour;
import jxl.write.Label;
import jxl.write.WritableCell;
import jxl.write.WritableCellFormat;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import jxl.write.WriteException;
import jxl.write.biff.RowsExceededException;
import org.apache.commons.lang.StringUtils;

public class JxlWorkBookStructure {
    private static final String YES_VALUE = "yes";
    private ArrayList<JxlSheetStructure> sheets;
    private Sheet[] workbookSheets;
    private int errorsLimit;
    private List<String> errors;
    private ResourceBundle resourceBundle;
    private ProgressBarService barService;

    public ArrayList<JxlSheetStructure> getSheets() {
        return this.sheets;
    }

    public void setSheets(ArrayList<JxlSheetStructure> sheets) {
        this.sheets = sheets;
    }

    public void addSheet(JxlSheetStructure sheet) {
        if (this.sheets == null) {
            this.sheets = new ArrayList();
        }
        this.sheets.add(sheet);
    }

    private JxlSheetStructure getSheetStructure(String name) {
        for (JxlSheetStructure sheet : this.sheets) {
            if (!name.equalsIgnoreCase(sheet.getName())) continue;
            return sheet;
        }
        return null;
    }

    private void validateSheetColumns(Sheet sheet) {
        HashSet<String> columnsSet = new HashSet<String>();
        Cell[] cells = sheet.getRow(0);
        if (cells == null) {
            return;
        }
        for (Cell cell : cells) {
            columnsSet.add(cell.getContents().toUpperCase());
        }
        JxlSheetStructure sheetStructure = this.getSheetStructure(sheet.getName());
        if (sheetStructure == null) {
            return;
        }
        ArrayList<JxlColumnStructure> columnsStructure = sheetStructure.getColumns();
        if (columnsStructure == null) {
            return;
        }
        for (JxlColumnStructure column : columnsStructure) {
            if (columnsSet.contains(column.getName().toUpperCase())) continue;
            String str = ResourceBundleUtil.getString(this.getResourceBundle(), "e.Jxl.Validation.SheetColumnMissing");
            String str1 = str.replace("{0}", sheet.getName());
            String str2 = str1.replace("{1}", column.getName());
            this.errors.add(str2);
            if (this.errorsLimit != this.errors.size()) continue;
            return;
        }
    }

    private void validateSheets() {
        HashSet<String> sheetsSet = new HashSet<String>();
        for (Sheet sheet : this.workbookSheets) {
            sheetsSet.add(sheet.getName().toUpperCase());
        }
        for (JxlSheetStructure sheet : this.sheets) {
            if (sheetsSet.contains(sheet.getName().toUpperCase()) || !sheet.isMandatory()) continue;
            this.errors.add(ResourceBundleUtil.getString(this.getResourceBundle(), "e.Jxl.Validation.SheetMissing").replace("{0}", sheet.getName()));
            if (this.errorsLimit != this.errors.size()) continue;
            return;
        }
    }

    public List<String> validate(Workbook workbook, int errorsLimit) {
        return this.validate(workbook, errorsLimit, false);
    }

    public List<String> validate(Workbook workbook, int errorsLimit, boolean monitorProgress) {
        int counter = 0;
        this.errorsLimit = errorsLimit;
        this.errors = new ArrayList<String>();
        this.workbookSheets = workbook.getSheets();
        this.validateSheets();
        if (this.errors.size() >= errorsLimit) {
            return this.errors;
        }
        for (Sheet sheet : this.workbookSheets) {
            int progressVal = 18 + (counter += 10) > 60 ? 60 : 18 + counter;
            this.monitorProgressSuccess("IMPORT_FL", "Validating " + sheet.getName() + " Excel Sheet...", progressVal, monitorProgress);
            this.validateSheetColumns(sheet);
            if (this.errors.size() < errorsLimit) continue;
            return this.errors;
        }
        return this.errors;
    }

    private void monitorProgressSuccess(String type, String uiLable, int value, boolean monitorProgress) {
        if (monitorProgress) {
            String message = ResourceBundleUtil.getString(this.getResourceBundle(), uiLable);
            this.getProgressBarService().updateStep(ProgressBar.Status.OK, type, message, value);
        }
    }

    private ResourceBundle getResourceBundle() {
        if (this.resourceBundle == null) {
            this.resourceBundle = CodeTablesResourceBundle.getDefaultBundle(null);
        }
        return this.resourceBundle;
    }

    private ProgressBarService getProgressBarService() {
        if (this.barService == null) {
            this.barService = (ProgressBarService)ServiceLocator.getInstance().lookUp(ProgressBarService.class);
        }
        return this.barService;
    }

    public void initWorkbook(WritableWorkbook workbook) throws RowsExceededException, WriteException {
        for (int i = 0; i < this.sheets.size(); ++i) {
            WritableSheet sheet = workbook.createSheet(this.sheets.get(i).getName(), i);
            this.sheets.get(i).initSheet(sheet);
        }
    }

    public void initWorkbookWithAutoSize(WritableWorkbook workbook) throws RowsExceededException, WriteException {
        for (int i = 0; i < this.sheets.size(); ++i) {
            WritableSheet sheet = workbook.createSheet(this.sheets.get(i).getName(), i);
            this.sheets.get(i).initSheetWithAutoSize(sheet);
        }
    }

    public HashMap<String, Integer> determineColumnsOrder(Sheet jxlSheet) {
        HashMap<String, Integer> columnsOrder = new HashMap<String, Integer>();
        String name = jxlSheet.getName();
        for (int i = 0; i < this.sheets.size(); ++i) {
            if (!name.equalsIgnoreCase(this.sheets.get(i).getName())) continue;
            columnsOrder = this.sheets.get(i).determineColumnsOrder(jxlSheet);
        }
        return columnsOrder;
    }

    public Cell getCellByName(Cell[] cells, HashMap<String, Integer> columnsOrder, String cellName) {
        Integer order = columnsOrder.get(cellName);
        if (order == null) {
            return null;
        }
        if (order >= cells.length) {
            return null;
        }
        return cells[order];
    }

    public static void writeStringField(WritableSheet sheet, int column, int row, String data) throws RowsExceededException, WriteException {
        Label cell = new Label(column, row, data);
        sheet.addCell((WritableCell)cell);
    }

    public static void writeStringField(WritableSheet sheet, int column, int row, String data, Colour colour) throws RowsExceededException, WriteException {
        WritableCellFormat cellFormat = new WritableCellFormat();
        try {
            cellFormat.setBackground(colour);
        }
        catch (WriteException e) {
            JxlWorkBookStructure.writeStringField(sheet, column, row, data);
        }
        Label cell = new Label(column, row, data, (CellFormat)cellFormat);
        sheet.addCell((WritableCell)cell);
    }

    public static void writeYesNoField(WritableSheet sheet, int column, int row, boolean data) throws RowsExceededException, WriteException {
        if (!data) {
            return;
        }
        Label cell = new Label(column, row, YES_VALUE);
        sheet.addCell((WritableCell)cell);
    }

    public static void writeCalendarField(WritableSheet sheet, int column, int row, Calendar data) throws RowsExceededException, WriteException {
        Date date = data.getTime();
        SynchronizedDateFormat dateFormatter = new SynchronizedDateFormat("MM/dd/yyyy");
        String str = dateFormatter.format(date);
        String dd = str.substring(0, 2);
        String mm = str.substring(3, 5);
        String yyyy = str.substring(6, 10);
        String jxlStr = dd + "/" + mm + "/" + yyyy;
        Label label = new Label(column, row, jxlStr);
        sheet.addCell((WritableCell)label);
    }

    public String getStringField(Cell[] cells, HashMap<String, Integer> columnsOrder, String cellName) {
        return this.getStringField(cells, columnsOrder, cellName, false);
    }

    public String getStringField(Cell[] cells, HashMap<String, Integer> columnsOrder, String cellName, boolean isIncludeSpaces) {
        Cell cell = this.getCellByName(cells, columnsOrder, cellName);
        if (cell == null) {
            return null;
        }
        String value = cell.getContents();
        if (!isIncludeSpaces) {
            if (com.exlibris.core.infra.common.util.StringUtils.isEmptyString(value)) {
                return null;
            }
            String trimmedValue = value.trim();
            return trimmedValue;
        }
        if (StringUtils.isEmpty((String)value)) {
            return null;
        }
        if (StringUtils.isNotBlank((String)value)) {
            return value.trim();
        }
        return value;
    }

    public boolean getYesNoField(Cell[] cells, HashMap<String, Integer> columnsOrder, String cellName) throws DigitoolException {
        Cell cell = this.getCellByName(cells, columnsOrder, cellName);
        if (cell == null) {
            return false;
        }
        String value = cell.getContents();
        if (com.exlibris.core.infra.common.util.StringUtils.isEmptyString(value)) {
            return false;
        }
        if (value.equalsIgnoreCase("y") || value.equalsIgnoreCase(YES_VALUE)) {
            return true;
        }
        if (value.equalsIgnoreCase("n") || value.equalsIgnoreCase("no")) {
            return false;
        }
        throw new DigitoolException(DescriptorConstants.GN_UnexpectedError, "Excel file error: logical cell has wrong value");
    }

    public Calendar getCalendarField(Cell[] cells, HashMap<String, Integer> columnsOrder, String cellName) throws ParseException {
        Cell cell = this.getCellByName(cells, columnsOrder, cellName);
        if (cell == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        CellType type = cell.getType();
        if (type == CellType.LABEL) {
            String str = cell.getContents();
            if (str == null) {
                return null;
            }
            String[] array = str.split("/");
            if (array.length != 3) {
                return null;
            }
            String dd = array[0];
            String mm = array[1];
            String yyyy = array[2];
            calendar.set(new Integer(yyyy), new Integer(mm) - 1, new Integer(dd));
            return calendar;
        }
        if (type == CellType.DATE) {
            Date date = ((DateCell)cell).getDate();
            calendar.setTime(date);
            return calendar;
        }
        return null;
    }
}

