/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.dps.ARValidator;

import com.exlibris.digitool.repository.api.xmlbeans.ArKey;
import com.exlibris.dps.ARValidator.ARValidator;
import com.exlibris.dps.ARValidator.AbsARValidator;
import com.exlibris.dps.ARValidator.AccessRightsPluginValidator;
import com.exlibris.dps.ARValidator.BorDeptMValidator;
import com.exlibris.dps.ARValidator.BorGroupMValidator;
import com.exlibris.dps.ARValidator.BorTuplesMValidator;
import com.exlibris.dps.ARValidator.ConcurrectUsersValidator;
import com.exlibris.dps.ARValidator.CourseEnrollmentMValidator;
import com.exlibris.dps.ARValidator.CustomValidator;
import com.exlibris.dps.ARValidator.DateCompareValidator;
import com.exlibris.dps.ARValidator.EveryoneValidator;
import com.exlibris.dps.ARValidator.ExpiryDateValidator;
import com.exlibris.dps.ARValidator.GroupValidator;
import com.exlibris.dps.ARValidator.IPRangeValidator;
import com.exlibris.dps.ARValidator.NotGuestValidator;
import com.exlibris.dps.ARValidator.UserIdValidator;

public class ARValidatorFactory {
    private static ARValidatorFactory singleARValidatorFactory = null;

    public ARValidator createArValidator(ArKey.Enum arKey) {
        String key = arKey.toString();
        AbsARValidator arValidtor = null;
        switch (key) {
            case "ip_range": {
                arValidtor = new IPRangeValidator();
                break;
            }
            case "everyone": {
                arValidtor = new EveryoneValidator();
                break;
            }
            case "date_compare": {
                arValidtor = new DateCompareValidator();
                break;
            }
            case "not_guest": {
                arValidtor = new NotGuestValidator();
                break;
            }
            case "expiry_date": {
                arValidtor = new ExpiryDateValidator();
                break;
            }
            case "concurrent_users": {
                arValidtor = new ConcurrectUsersValidator();
                break;
            }
            case "group": {
                arValidtor = new GroupValidator();
                break;
            }
            case "user_id": {
                arValidtor = new UserIdValidator();
                break;
            }
            case "bor_group_m": {
                arValidtor = new BorGroupMValidator();
                break;
            }
            case "bor_dept_m": {
                arValidtor = new BorDeptMValidator();
                break;
            }
            case "bor_tuples_m": {
                arValidtor = new BorTuplesMValidator();
                break;
            }
            case "course_enrollment_m": {
                arValidtor = new CourseEnrollmentMValidator();
                break;
            }
            case "access_rights_plugin": {
                arValidtor = new AccessRightsPluginValidator();
                break;
            }
            case "custom": {
                arValidtor = new CustomValidator();
                break;
            }
        }
        return arValidtor;
    }

    public static ARValidatorFactory getInstance() {
        if (singleARValidatorFactory == null) {
            singleARValidatorFactory = new ARValidatorFactory();
        }
        return singleARValidatorFactory;
    }

    protected ARValidatorFactory() {
    }
}

