/*
 * Decompiled with CFR 0.152.
 */
package ch.docuteam.darc.util;

import ch.docuteam.darc.mdconfig.RDFMetadataValue;
import ch.docuteam.tools.file.ResourceUtil;
import ch.docuteam.tools.out.Logger;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.impl.LinkedHashModel;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.RDFParser;
import org.eclipse.rdf4j.rio.Rio;
import org.eclipse.rdf4j.rio.helpers.StatementCollector;

public class RDF_SKOS_Reader {
    public static RDF_SKOS_Reader getRDFReader() {
        return new RDF_SKOS_Reader();
    }

    Model parseRDF(String documentURLString) {
        LinkedHashModel model = null;
        URL documentURL = null;
        try {
            documentURL = ResourceUtil.getResourceURL((String)new URL(documentURLString).getFile());
        }
        catch (MalformedURLException e) {
            Logger.error((Object)"parseRDF failed: ", (Throwable)e);
        }
        if (documentURL != null) {
            try (InputStream inputStream = documentURL.openStream();){
                RDFParser rdfParser = Rio.createParser((RDFFormat)RDFFormat.RDFXML);
                model = new LinkedHashModel();
                rdfParser.setRDFHandler((RDFHandler)new StatementCollector((Collection)model));
                rdfParser.parse(inputStream, documentURL.toString());
            }
            catch (IOException e) {
                Logger.error((Object)"parseRDF failed: ", (Throwable)e);
            }
        }
        return model;
    }

    public List<RDFMetadataValue> getAllowedValuesList(String documentURLString) {
        ArrayList<RDFMetadataValue> allowedValues = new ArrayList<RDFMetadataValue>();
        ArrayListMultimap allRDFMetadataValues = ArrayListMultimap.create();
        Model model = this.parseRDF(documentURLString);
        if (model != null) {
            Iterator modelIterator = model.iterator();
            Set<String> coreConceptSubjectUriSet = RDFMetadataValue.getCoreConceptSubjectURIs(model);
            while (modelIterator.hasNext()) {
                RDFMetadataValue valueEN;
                Statement nextStatement = (Statement)modelIterator.next();
                Logger.debug((Object)("nextStatement: " + nextStatement.getSubject() + " - " + nextStatement.getPredicate() + " - " + nextStatement.getObject()));
                RDFMetadataValue valueFR = RDFMetadataValue.createRDFMetadataValue(nextStatement, RDFMetadataValue.getSKOSDefaultLanguage(), coreConceptSubjectUriSet);
                if (valueFR != null) {
                    allRDFMetadataValues.put((Object)nextStatement.getSubject().stringValue(), (Object)valueFR);
                }
                if ((valueEN = RDFMetadataValue.createRDFMetadataValue(nextStatement, RDFMetadataValue.LANGUAGE.EN, coreConceptSubjectUriSet)) == null) continue;
                allRDFMetadataValues.put((Object)nextStatement.getSubject().stringValue(), (Object)valueEN);
            }
        }
        this.keepOnlyOneRDFMetadataValuePerCoreConcept(allowedValues, (ListMultimap<String, RDFMetadataValue>)allRDFMetadataValues);
        Collections.sort(allowedValues);
        return allowedValues;
    }

    private void keepOnlyOneRDFMetadataValuePerCoreConcept(List<RDFMetadataValue> allowedValues, ListMultimap<String, RDFMetadataValue> allRDFMetadataValues) {
        for (String nextKey : allRDFMetadataValues.keySet()) {
            RDFMetadataValue rdfMetadataValue;
            List valueList = allRDFMetadataValues.get((Object)nextKey);
            if (valueList.size() == 1) {
                rdfMetadataValue = (RDFMetadataValue)valueList.get(0);
                allowedValues.add(rdfMetadataValue);
                continue;
            }
            if (valueList.size() <= 1) continue;
            rdfMetadataValue = (RDFMetadataValue)valueList.get(0);
            if (!RDFMetadataValue.LANGUAGE.EN.equals((Object)rdfMetadataValue.getLanguage())) {
                rdfMetadataValue.setLabelEN(((RDFMetadataValue)valueList.get(1)).getLabel());
            } else {
                rdfMetadataValue = (RDFMetadataValue)valueList.get(1);
                rdfMetadataValue.setLabelEN(((RDFMetadataValue)valueList.get(0)).getLabel());
            }
            allowedValues.add(rdfMetadataValue);
        }
    }
}

