/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.svc.api.locator;

import com.exlibris.core.infra.common.exceptions.logging.ExLogger;
import com.exlibris.core.infra.common.javaclass.PluginInvokationHandler;
import com.exlibris.core.infra.model.plugins.HFrPluginInstance;
import com.exlibris.core.infra.model.plugins.HFrPluginType;
import com.exlibris.core.infra.model.plugins.PluginImplType;
import com.exlibris.core.infra.model.plugins.PluginMetadata;
import com.exlibris.core.infra.model.plugins.PluginStatus;
import com.exlibris.core.infra.svc.api.GeneralParameterManager;
import com.exlibris.core.infra.svc.api.PluginManager;
import com.exlibris.core.infra.svc.api.locator.ServiceLocator;
import com.exlibris.core.infra.svc.api.plugins.PluginNotActiveException;
import com.exlibris.core.infra.svc.api.plugins.PluginUtils;
import com.exlibris.core.infra.svc.api.plugins.PluginsInitializatorUtils;
import com.exlibris.core.infra.svc.api.scriptRunner.ScriptPluginRunner;
import com.exlibris.digitool.common.forms.xmlbeans.XFields;
import com.exlibris.digitool.common.forms.xmlbeans.XFormDocument;
import java.io.File;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class PluginLocator {
    private static ExLogger log = ExLogger.getExLogger(PluginLocator.class);
    private PluginManager pluginManager;
    private static PluginLocator pluginLocator;
    private String bundledPluginDir;
    private String customPluginDir;
    private GeneralParameterManager generalParameterManager;

    public static PluginLocator getInstance() {
        if (pluginLocator == null) {
            pluginLocator = new PluginLocator();
        }
        return pluginLocator;
    }

    public <T> T lookUp(Class<?> T, String pluginName) {
        HFrPluginInstance plugin;
        if (pluginName != null) {
            pluginName = pluginName.trim();
        }
        if (!PluginStatus.ACTIVE.equals((Object)(plugin = this.getPluginManager().getPluginMetadataByPluginName("CRS00", pluginName, null)).getStatus())) {
            log.error("failed to load plug-in, plug-in is not activate", new String[0]);
            throw new PluginNotActiveException("Unable to create instance of: " + plugin.getImplName() + " plug-in is not activate");
        }
        if (plugin.getPluginImplType() == PluginImplType.SCRIPT) {
            return this.lookUpScript(T, plugin);
        }
        return this.createNewInstance(T, plugin, PluginImplType.JAVA);
    }

    private <T> T lookUpScript(Class<?> T, HFrPluginInstance pluginInstance) {
        String scriptName = this.correctScriptNameByOS(pluginInstance.getImplName());
        String pluginName = pluginInstance.getPluginName();
        double version = pluginInstance.getPluginVersion();
        HFrPluginInstance.DeploymentMode deploymentMode = pluginInstance.getDeploymentMode();
        try {
            List<PluginMetadata> metadatas = this.getPluginManager().getPluginMetadatas(this.getPluginDirectory(deploymentMode), this.getPluginDirectory(deploymentMode) + pluginInstance.getJarFileName());
            PluginMetadata metadata = metadatas.get(0);
            pluginName = metadata.getPluginName();
            version = metadata.getPluginVersion();
        }
        catch (Exception e) {
            log.warn((Object)("Couldn't get script's plugin name and version from the metadata file, using DB info: " + pluginName + ", " + version), new String[0]);
        }
        String scriptFullName = new File(this.getScriptDeployedDirectory(deploymentMode) + File.separator + PluginUtils.getValidPathName(pluginName + "-Vr-" + version) + File.separator + scriptName).getAbsolutePath();
        List<String> initialArgs = this.getInitialScriptArgs(pluginInstance);
        T scriptInstance = this.createNewInstance(T, pluginInstance, PluginImplType.SCRIPT);
        ((ScriptPluginRunner)scriptInstance).setInitialArgs(initialArgs);
        ((ScriptPluginRunner)scriptInstance).setCommand(scriptFullName);
        return scriptInstance;
    }

    private <T> T createNewInstance(Class<?> T, HFrPluginInstance plugin, PluginImplType deploymentMode) {
        try {
            if (deploymentMode == PluginImplType.JAVA) {
                URLClassLoader classLoader = PluginsInitializatorUtils.getPluginClassLoader(this.getDeployedJarsDirectory(plugin.getDeploymentMode()), plugin.getJarFileName(), plugin.getPluginVersion());
                Object pluginInstance = classLoader.loadClass(plugin.getImplName()).newInstance();
                Map<String, String> initialParams = PluginUtils.getInitialParams(plugin);
                PluginInvokationHandler pluginInvocationHandler = new PluginInvokationHandler(pluginInstance, classLoader, initialParams);
                return (T)Proxy.newProxyInstance(classLoader, new Class[]{T}, (InvocationHandler)pluginInvocationHandler);
            }
            T clazz = null;
            HFrPluginType pluginType = plugin.getPluginType();
            clazz = !StringUtils.isEmpty((String)pluginType.getScriptRunnerClass()) ? (T)Class.forName(pluginType.getScriptRunnerClass()).newInstance() : (T)Class.forName(pluginType.getPluginInterface()).newInstance();
            return clazz;
        }
        catch (Exception e) {
            log.error("Unable to create instance of:" + plugin.getImplName() + " type:" + (Object)((Object)deploymentMode), e, new String[0]);
            throw new RuntimeException("Unable to create instance of:" + plugin.getImplName() + " type:" + (Object)((Object)deploymentMode));
        }
    }

    private List<String> getInitialScriptArgs(HFrPluginInstance pluginInstance) {
        XFields.XField[] xfieldArr;
        XFormDocument xformDocument = null;
        ArrayList<String> ret = new ArrayList<String>();
        if (pluginInstance.getInitParmXml() == null) {
            return ret;
        }
        try {
            xformDocument = XFormDocument.Factory.parse(pluginInstance.getInitParmXml());
        }
        catch (Exception e) {
            throw new RuntimeException("Problem getting args for plugin:" + pluginInstance.getPluginName());
        }
        if (xformDocument.getXForm() == null || xformDocument.getXForm().getXFields() == null || xformDocument.getXForm().getXFields().getXFieldArray() == null) {
            return ret;
        }
        for (XFields.XField xfield : xfieldArr = xformDocument.getXForm().getXFields().getXFieldArray()) {
            ret.add(xfield.getDefaultValue());
        }
        return ret;
    }

    private String correctScriptNameByOS(String scriptName) {
        String osName = System.getProperty("os.name");
        if (osName.equals("Unix") || osName.equals("Linux") || osName.equals("SunOS")) {
            if (!scriptName.endsWith(".sh")) {
                scriptName = scriptName.split("\\.")[0] + ".sh";
            }
        } else if (!scriptName.endsWith(".bat")) {
            scriptName = scriptName.split("\\.")[0] + ".bat";
        }
        scriptName = scriptName.replace("\\", File.separator);
        scriptName = scriptName.replace("/", File.separator);
        return scriptName;
    }

    private PluginManager getPluginManager() {
        if (this.pluginManager == null) {
            this.pluginManager = (PluginManager)ServiceLocator.getInstance().lookUp(PluginManager.class);
        }
        return this.pluginManager;
    }

    private GeneralParameterManager getGeneralParameterManager() {
        if (this.generalParameterManager == null) {
            this.generalParameterManager = (GeneralParameterManager)ServiceLocator.getInstance().lookUp(GeneralParameterManager.class);
        }
        return this.generalParameterManager;
    }

    public String getPluginDirectory(HFrPluginInstance.DeploymentMode deploymentMode) {
        if (deploymentMode == HFrPluginInstance.DeploymentMode.BUNDLED) {
            if (this.bundledPluginDir == null) {
                String operationalShared = this.getGeneralParameterManager().getParameter("general", "operational_shared");
                this.bundledPluginDir = operationalShared + File.separator + "plugins" + File.separator + "bundled" + File.separator;
            }
            return this.bundledPluginDir;
        }
        if (this.customPluginDir == null) {
            String operationalShared = this.getGeneralParameterManager().getParameter("general", "operational_shared");
            this.customPluginDir = operationalShared + File.separator + "plugins" + File.separator + "custom" + File.separator;
        }
        return this.customPluginDir;
    }

    public String getDeployedJarsDirectory(HFrPluginInstance.DeploymentMode deploymentMode) {
        return this.getPluginDirectory(deploymentMode) + "deploy" + File.separator;
    }

    public String getScriptDeployedDirectory(HFrPluginInstance.DeploymentMode deploymentMode) {
        return this.getPluginDirectory(deploymentMode) + "bin" + File.separator;
    }
}

