/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.svc.api.plugins;

import com.exlibris.core.infra.common.exceptions.InfraException;
import com.exlibris.core.infra.common.exceptions.logging.DescriptorConstants;
import com.exlibris.core.infra.common.util.IOUtil;
import com.exlibris.core.infra.common.util.StringUtils;
import com.exlibris.core.infra.model.plugins.HFrPluginInstance;
import com.exlibris.core.infra.model.plugins.PluginContactPerson;
import com.exlibris.core.infra.model.plugins.PluginMetadata;
import com.exlibris.digitool.common.forms.xmlbeans.XFields;
import com.exlibris.digitool.common.forms.xmlbeans.XFormDocument;
import com.exlibrisgroup.plugins.x10.Config;
import com.exlibrisgroup.plugins.x10.ContactInfoDocument;
import com.exlibrisgroup.plugins.x10.ContactPerson;
import com.exlibrisgroup.plugins.x10.InitXml;
import com.exlibrisgroup.plugins.x10.MetadataConfigDocument;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.collections.comparators.ComparableComparator;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.XmlException;

public class PluginUtils {
    private static final Logger logger = Logger.getLogger(PluginUtils.class);
    private static final String PLUGIN_VERSION_INIT_PARAM = "PLUGIN_VERSION_INIT_PARAM";

    public List<PluginMetadata> sortMetadataList(List<PluginMetadata> list, String column, String order) {
        if (list == null) {
            return null;
        }
        BeanComparator comp = new BeanComparator(column, order);
        Collections.sort(list, comp);
        return list;
    }

    public PluginMetadata parseMetadataAsString(String metadataString) throws Exception {
        MetadataConfigDocument metaConfigDoc = null;
        try {
            metaConfigDoc = MetadataConfigDocument.Factory.parse(metadataString);
        }
        catch (XmlException e) {
            throw new Exception(e.getMessage());
        }
        return this.parseMetadata(metaConfigDoc);
    }

    public PluginMetadata parseMetadataAsFileName(String metadataFileName) throws Exception {
        MetadataConfigDocument metaConfigDoc = null;
        File metadata = new File(metadataFileName);
        try {
            metaConfigDoc = MetadataConfigDocument.Factory.parse(metadata);
        }
        catch (IOException e) {
            throw new Exception(e.getMessage());
        }
        catch (XmlException e) {
            throw new Exception(e.getMessage());
        }
        return this.parseMetadata(metaConfigDoc);
    }

    private PluginMetadata parseMetadata(MetadataConfigDocument metaConfigDoc) throws Exception {
        Config[] configArray;
        ContactPerson[] contactPersonArray;
        PluginMetadata pluginMetadata = new PluginMetadata();
        MetadataConfigDocument.MetadataConfig metadataConfig = metaConfigDoc.getMetadataConfig();
        pluginMetadata.setPluginTypeName(metadataConfig.getPluginTypeName());
        pluginMetadata.setPluginName(metadataConfig.getDeployName());
        pluginMetadata.setImplName(metadataConfig.getClassName());
        pluginMetadata.setPluginImplType(metadataConfig.getImplType());
        InitXml parmsXml = metadataConfig.getInitParameters();
        try {
            XFormDocument.Factory.parse(parmsXml.toString());
            pluginMetadata.setParmsXml(parmsXml.toString());
        }
        catch (Throwable e) {
            logger.info((Object)("Form XMl of InitParameters section is not valid in: " + metadataConfig.getPluginTypeName() + " - " + metadataConfig.getDeployName()));
        }
        pluginMetadata.setDescription(metadataConfig.getDescription());
        double version = Double.parseDouble(metadataConfig.getVersion());
        pluginMetadata.setPluginVersion(version);
        pluginMetadata.setMaterialType(metadataConfig.getMaterialType());
        pluginMetadata.setResourceType(metadataConfig.getResourceType());
        pluginMetadata.setModule(metadataConfig.getModule());
        pluginMetadata.setGeneralType(metadataConfig.getGeneralType());
        if (metadataConfig.getPublicApi() != null && (metadataConfig.getPublicApi().equalsIgnoreCase("N") || metadataConfig.getPublicApi().equalsIgnoreCase("NO"))) {
            pluginMetadata.setAllowedPublicAPI(false);
        } else if (metadataConfig.getPublicApi() != null && (metadataConfig.getPublicApi().equalsIgnoreCase("Y") || metadataConfig.getPublicApi().equalsIgnoreCase("Yes"))) {
            pluginMetadata.setAllowedPublicAPI(true);
        }
        pluginMetadata.setPluginType(metadataConfig.getImplType());
        for (ContactPerson cperson : contactPersonArray = metadataConfig.getContactPersonArray()) {
            pluginMetadata.setContactPerson(cperson.toString());
        }
        for (Config config : configArray = metadataConfig.getConfigurationArray()) {
            pluginMetadata.setConfigXml(config.toString());
        }
        return pluginMetadata;
    }

    public PluginContactPerson parseContactPersonXml(String contactPersonAsXml) throws Exception {
        PluginContactPerson contactPerson = new PluginContactPerson();
        ContactInfoDocument contactDoc = null;
        try {
            contactDoc = ContactInfoDocument.Factory.parse(contactPersonAsXml);
        }
        catch (XmlException e) {
            throw new Exception(e.getMessage());
        }
        ContactInfoDocument.ContactInfo contact = contactDoc.getContactInfo();
        contactPerson.setContactType(contact.getContactType().toString());
        contactPerson.setLastName(contact.getLastName());
        contactPerson.setFirstName(contact.getFirstName());
        contactPerson.setEmail(contact.getEmail());
        contactPerson.setTelephone1(contact.getTelephone1());
        contactPerson.setTelephone2(contact.getTelephone2());
        contactPerson.setAddress1(contact.getAddress1());
        contactPerson.setAddress2(contact.getAddress2());
        contactPerson.setCity(contact.getCity());
        contactPerson.setZipCode(contact.getZipCode());
        contactPerson.setCountry(contact.getCountry());
        return contactPerson;
    }

    public boolean isInterfaceImplemented(String filename, String pluginInterface) throws InfraException {
        File file = new File(filename);
        try {
            URL url = file.toURL();
            URL[] urls = new URL[]{url};
            URLClassLoader cl = new URLClassLoader(urls);
            JarFile jarFile = new JarFile(filename);
            Enumeration<JarEntry> e = jarFile.entries();
            while (e.hasMoreElements()) {
                Class<?>[] iArray;
                JarEntry entry = e.nextElement();
                String entryname = entry.getName();
                if (entry.isDirectory() || !entryname.endsWith(".class")) continue;
                String classname = entryname.substring(0, entryname.length() - 6);
                if (classname.startsWith("/")) {
                    classname = classname.substring(1);
                }
                classname = classname.replace('/', '.');
                Class<?> c = cl.loadClass(classname);
                for (Class<?> i : iArray = c.getInterfaces()) {
                    logger.info((Object)("CLASS " + c));
                    logger.info((Object)("INTERFACE " + i));
                    if (!pluginInterface.contains(i.getCanonicalName())) continue;
                    return true;
                }
            }
        }
        catch (MalformedURLException e) {
            logger.error((Object)("Interface verification failed - malformed url " + e.getMessage()));
            throw new InfraException(DescriptorConstants.DES_operationFailed, e.getMessage());
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)("Interface verification failed - class not found " + e.getMessage()));
            throw new InfraException(DescriptorConstants.DES_operationFailed, e.getMessage());
        }
        catch (IOException e) {
            logger.error((Object)("Interface verification failed  - io error " + e.getMessage()));
            throw new InfraException(DescriptorConstants.DES_operationFailed, e.getMessage());
        }
        return false;
    }

    public List<StringBuffer> getFileFromJar(String jarFile) throws Exception {
        ArrayList<StringBuffer> strBuffers = new ArrayList<StringBuffer>();
        InputStream entryStream = null;
        try {
            JarFile jar = new JarFile(jarFile);
            Enumeration<JarEntry> entries = jar.entries();
            if (entries != null) {
                while (entries.hasMoreElements()) {
                    int bytesRead;
                    JarEntry entry = entries.nextElement();
                    if (entry == null || !entry.getName().startsWith("PLUGIN-INF") || !entry.getName().contains("metadata") || !entry.getName().endsWith(".xml")) continue;
                    StringBuffer strBuffer = new StringBuffer();
                    entryStream = jar.getInputStream(entry);
                    InputStreamReader is = new InputStreamReader(entryStream);
                    char[] b = new char[1024];
                    while ((bytesRead = is.read(b)) != -1) {
                        strBuffer.append(b, 0, bytesRead);
                    }
                    strBuffers.add(strBuffer);
                }
            }
        }
        catch (IOException e) {
            throw new Exception(e.getMessage());
        }
        finally {
            IOUtil.closeQuietly(entryStream);
        }
        return strBuffers;
    }

    public void extractAndMoveFiles(String jarFile, String implName, String outputDirectory) throws InfraException {
        InputStream entryStream = null;
        FileOutputStream file = null;
        try {
            this.createDirectory(outputDirectory);
            JarFile jar = new JarFile(jarFile);
            Enumeration<JarEntry> enteries = jar.entries();
            if (enteries != null) {
                while (enteries.hasMoreElements()) {
                    int bytesRead;
                    JarEntry entry = enteries.nextElement();
                    String name = entry.getName();
                    if (StringUtils.isEmptyString(name)) continue;
                    if (this.getEntryName(name).startsWith(implName)) {
                        name = this.getEntryName(name);
                    }
                    entryStream = jar.getInputStream(entry);
                    File fileF = new File(outputDirectory + File.separator + name);
                    if (name.lastIndexOf(File.separator) == name.length() - 1 || name.lastIndexOf(47) == name.length() - 1) {
                        this.createDirectory(outputDirectory + File.separator + name);
                        continue;
                    }
                    fileF.createNewFile();
                    file = new FileOutputStream(fileF, false);
                    byte[] buffer = new byte[1024];
                    while ((bytesRead = entryStream.read(buffer)) != -1) {
                        file.write(buffer, 0, bytesRead);
                    }
                    file.close();
                    fileF.setExecutable(true, false);
                    fileF.setReadable(true, false);
                    fileF.setWritable(false, false);
                }
            }
        }
        catch (IOException e) {
            IOUtil.closeQuietly(file);
            throw new InfraException(DescriptorConstants.DES_operationFailed, e.getMessage());
        }
        finally {
            IOUtil.closeQuietly(file);
            IOUtil.closeQuietly(entryStream);
        }
    }

    private void createDirectory(String outputDirectory) throws IOException {
        File directory = new File(outputDirectory);
        if (!directory.exists()) {
            directory.mkdir();
            directory.setWritable(true);
        }
    }

    private String getEntryName(String entryName) {
        String result = entryName;
        if (entryName.lastIndexOf("/") != -1) {
            result = entryName.substring(entryName.lastIndexOf("/") + 1);
        }
        if (entryName.lastIndexOf("\\") != -1) {
            result = entryName.substring(entryName.lastIndexOf("\\")) + 1;
        }
        return result;
    }

    public static void copyFile(File in, File out) throws Exception {
        FileUtils.copyFile((File)in, (File)out);
    }

    public static void listFilesRecursive(File dirPath, List filesList, String extension) {
        File[] files = null;
        if (dirPath.isDirectory()) {
            files = dirPath.listFiles();
            for (int i = 0; i < files.length; ++i) {
                PluginUtils.listFilesRecursive(files[i], filesList, extension);
            }
        } else if (extension == null || PluginUtils.getExtension(dirPath.getName()).equals(extension)) {
            filesList.add(dirPath.getAbsolutePath());
        }
    }

    public static void listFiles(File dirPath, List filesList, String extension) {
        File[] files = null;
        if (dirPath.isDirectory()) {
            files = dirPath.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (extension != null && !PluginUtils.getExtension(files[i].getName()).equals(extension)) continue;
                filesList.add(files[i].getAbsolutePath());
            }
        }
    }

    public static String getExtension(String filename) {
        int index = filename.lastIndexOf(46);
        if (-1 == index) {
            return "";
        }
        return filename.substring(index + 1);
    }

    public void loadClassesFromJar(String jarName) {
        try {
            URLClassLoader urlLoader = PluginUtils.getURLClassLoader(new URL("file", null, jarName));
            JarInputStream jis = new JarInputStream(new FileInputStream(jarName));
            JarEntry entry = jis.getNextJarEntry();
            Class<?> clazz = null;
            while (entry != null) {
                String name = entry.getName();
                if (name.endsWith(".class")) {
                    name = name.substring(0, name.length() - 6);
                    name = name.replace('/', '.');
                    clazz = urlLoader.loadClass(name);
                    logger.info((Object)("\t- loaded " + name));
                }
                entry = jis.getNextJarEntry();
            }
        }
        catch (Exception e) {
            logger.error((Object)("Failed to load classess from jar file - " + jarName + e.getMessage()));
        }
    }

    private static URLClassLoader getURLClassLoader(URL jarURL) {
        ClassLoader parent = Thread.currentThread().getContextClassLoader();
        return new URLClassLoader(new URL[]{jarURL}, parent);
    }

    public static void addFilesToExistingZip(File zipFile, File[] files) throws IOException {
        File tempFile = File.createTempFile(zipFile.getName(), null);
        tempFile.delete();
        boolean renameOk = zipFile.renameTo(tempFile);
        if (!renameOk) {
            throw new RuntimeException("could not rename the file " + zipFile.getAbsolutePath() + " to " + tempFile.getAbsolutePath());
        }
        byte[] buf = new byte[1024];
        ZipInputStream zin = new ZipInputStream(new FileInputStream(tempFile));
        ZipOutputStream out = new ZipOutputStream(new FileOutputStream(zipFile));
        ZipEntry entry = zin.getNextEntry();
        while (entry != null) {
            String name = entry.getName();
            boolean notInFiles = true;
            for (File f : files) {
                if (!f.getName().equals(name)) continue;
                notInFiles = false;
                break;
            }
            if (notInFiles) {
                int len;
                out.putNextEntry(new ZipEntry(name));
                while ((len = zin.read(buf)) > 0) {
                    out.write(buf, 0, len);
                }
            }
            entry = zin.getNextEntry();
        }
        zin.close();
        for (int i = 0; i < files.length; ++i) {
            int len;
            FileInputStream in = new FileInputStream(files[i]);
            out.putNextEntry(new ZipEntry(files[i].getName()));
            while ((len = ((InputStream)in).read(buf)) > 0) {
                out.write(buf, 0, len);
            }
            out.closeEntry();
            ((InputStream)in).close();
        }
        out.close();
        tempFile.delete();
    }

    public static String getValidPathName(String directory) {
        return directory.replaceAll("[< > : \" / \\ \\\\ | ? *]", ".");
    }

    public static void main(String[] args) throws Exception {
        ArrayList filesList = new ArrayList();
        PluginUtils.listFiles(new File("E:\\dps\\Rosetta-HEAD\\profile\\operational_shared\\plugins"), filesList, "jar");
        for (String f : filesList) {
            System.out.println(f);
        }
    }

    public static Map<String, String> getInitialParams(HFrPluginInstance pluginInstance) {
        XFields.XField[] xfieldArr;
        XFormDocument xformDocument = null;
        HashMap<String, String> ret = new HashMap<String, String>();
        ret.put(PLUGIN_VERSION_INIT_PARAM, String.valueOf(pluginInstance.getPluginVersion()));
        if (pluginInstance.getInitParmXml() == null) {
            return ret;
        }
        try {
            xformDocument = XFormDocument.Factory.parse(pluginInstance.getInitParmXml());
        }
        catch (Exception e) {
            throw new RuntimeException("Problem getting args for plugin:" + pluginInstance.getPluginName());
        }
        if (xformDocument.getXForm() == null || xformDocument.getXForm().getXFields() == null || xformDocument.getXForm().getXFields().getXFieldArray() == null) {
            return ret;
        }
        for (XFields.XField xfield : xfieldArr = xformDocument.getXForm().getXFields().getXFieldArray()) {
            ret.put(xfield.getFieldName(), xfield.getDefaultValue());
        }
        return ret;
    }

    public class BeanComparator
    implements Comparator<PluginMetadata> {
        private String attribute;
        private Comparator comp = new ComparableComparator();

        public BeanComparator(String attrib, String order) {
            if (order.compareToIgnoreCase("Asc") != 0) {
                this.comp = Collections.reverseOrder(this.comp);
            }
            this.attribute = attrib;
        }

        @Override
        public int compare(PluginMetadata o1, PluginMetadata o2) {
            if (o1 == null) {
                return 1;
            }
            if (o2 == null) {
                return -1;
            }
            try {
                Object ret1 = PropertyUtils.getProperty((Object)o1, (String)this.attribute);
                Object ret2 = PropertyUtils.getProperty((Object)o2, (String)this.attribute);
                return this.comp.compare(ret1.toString().toUpperCase(), ret2.toString().toUpperCase());
            }
            catch (Exception e) {
                return 0;
            }
        }
    }
}

