/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.svc.api.resourcemanagement;

import com.exlibris.core.infra.common.util.StringUtils;
import com.exlibris.core.infra.svc.api.config.GlobalProperties;
import com.exlibris.core.infra.svc.api.schema.DBSchemaUtil;
import javax.jms.Message;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;

public class MyTopicSubscriber {
    private TopicConnection connection;
    private TopicSession session;
    private TopicSubscriber subscriber;
    public static final String SERVER_ID = StringUtils.toAlphaNumeric(GlobalProperties.getInstance().getProperty("server.name"));

    public MyTopicSubscriber(TopicConnection connection, String name, String messageSelector) throws Exception {
        this.connection = connection;
        this.session = connection.createTopicSession(false, 1);
        connection.start();
        if (!name.startsWith(DBSchemaUtil.SHR_SCHEMA + ".")) {
            name = DBSchemaUtil.SHR_SCHEMA + "." + name;
        }
        Topic topic = this.session.createTopic(name);
        this.subscriber = this.session.createDurableSubscriber(topic, SERVER_ID, messageSelector, false);
    }

    public void close() {
        if (this.subscriber != null) {
            try {
                this.subscriber.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (this.session != null) {
            try {
                this.session.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public Message receive(long waitTime) throws Exception {
        return this.subscriber.receive(waitTime);
    }
}

