/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.svc.api.scriptRunner;

import com.exlibris.core.infra.common.fsutils.InfraFSUtil;
import com.exlibris.core.infra.svc.api.scriptRunner.ExecLocal;
import com.exlibris.core.infra.svc.api.scriptRunner.ExecPipe;
import com.exlibris.core.infra.svc.api.scriptRunner.ExecStrategy;
import com.exlibris.core.infra.svc.api.scriptRunner.ExecWrapper;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class ExecExternalProcess {
    private static final long serialVersionUID = 0L;
    public static final String LOCAL_STRATEGY = "local";
    public static final String PIPE_STRATEGY = "pipe";
    public static final String WRAPPER_STRATEGY = "wrapper";
    private static final String PIPE_SCRIPT = File.separator + "bin" + File.separator + "exec_pipe.sh";
    private static final ThreadLocal<ExecStrategy> threadExecStrategy = new ThreadLocal<ExecStrategy>(){

        @Override
        protected ExecStrategy initialValue() {
            String strategyName = System.getProperty("exec.strategy");
            String string = strategyName = StringUtils.isBlank((String)strategyName) ? ExecExternalProcess.WRAPPER_STRATEGY : strategyName;
            if (strategyName.equals(ExecExternalProcess.LOCAL_STRATEGY)) {
                return new ExecLocal();
            }
            if (strategyName.equals(ExecExternalProcess.PIPE_STRATEGY)) {
                String pipeScriptPath = InfraFSUtil.getSystemDir() + PIPE_SCRIPT;
                try {
                    return new ExecPipe(pipeScriptPath);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return null;
                }
            }
            if (strategyName.equals(ExecExternalProcess.WRAPPER_STRATEGY)) {
                return new ExecWrapper();
            }
            return null;
        }
    };

    public static ExecStrategy getStrategy() {
        return threadExecStrategy.get();
    }

    public int execExternalProcess(String cmd, List<String> args) {
        return ExecExternalProcess.getStrategy().execExternalProcess(cmd, args);
    }

    public void setExitValue(int exitValue) {
        ExecExternalProcess.getStrategy().setExitValue(exitValue);
    }

    public void setInputStream(String inputStream) {
        ExecExternalProcess.getStrategy().setInputStream(inputStream);
    }

    public void setErrorStream(String errorStream) {
        ExecExternalProcess.getStrategy().setErrorStream(errorStream);
    }

    public int getExitValue() {
        return ExecExternalProcess.getStrategy().getExitValue();
    }

    public String getInputStream() {
        return ExecExternalProcess.getStrategy().getInputStream();
    }

    public String getErrorStream() {
        return ExecExternalProcess.getStrategy().getErrorStream();
    }

    public String getCmd() {
        return ExecExternalProcess.getStrategy().getCmd();
    }

    public void setCmd(String cmd) {
        ExecExternalProcess.getStrategy().setCmd(cmd);
    }

    public List<String> getArgs() {
        return ExecExternalProcess.getStrategy().getArgs();
    }

    public void setArgs(List<String> args) {
        ExecExternalProcess.getStrategy().setArgs(args);
    }
}

