/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.digitool.common.streams;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;

public class UTF8FileInputStream
extends FileInputStream {
    private static final int BOM_EF = 239;
    private static final int BOM_BB = 187;
    private static final int BOM_BF = 191;

    public UTF8FileInputStream(String name) throws FileNotFoundException {
        this(new File(name));
    }

    public UTF8FileInputStream(File file) throws FileNotFoundException {
        super(file);
        try {
            UTF8FileInputStream.skipBom(this);
        }
        catch (IOException e) {
            throw new FileNotFoundException(e.getMessage());
        }
    }

    private static FileInputStream skipBom(FileInputStream is) throws IOException {
        if (is.available() > 3) {
            int i1 = is.read();
            int i2 = is.read();
            int i3 = is.read();
            if (i1 != 239 || i2 != 187 || i3 != 191) {
                is.getChannel().position(0L);
            }
        }
        return is;
    }
}

