/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.digitool.utils;

import com.exlibris.digitool.utils.JxlColumnStructure;
import java.util.ArrayList;
import java.util.HashMap;
import jxl.Cell;
import jxl.CellView;
import jxl.Sheet;
import jxl.write.Label;
import jxl.write.WritableCell;
import jxl.write.WritableSheet;
import jxl.write.WriteException;
import jxl.write.biff.RowsExceededException;

public class JxlSheetStructure {
    private String name = null;
    private boolean mandatory = true;
    private ArrayList<JxlColumnStructure> columns = null;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isMandatory() {
        return this.mandatory;
    }

    public void setMandatory(boolean mandatory) {
        this.mandatory = mandatory;
    }

    public ArrayList<JxlColumnStructure> getColumns() {
        return this.columns;
    }

    public void setColumns(ArrayList<JxlColumnStructure> columns) {
        this.columns = columns;
    }

    public void addColumn(String name) {
        this.addColumn(name, false);
    }

    public void addColumn(String name, boolean isKeyColumn) {
        this.addColumn(name, JxlColumnStructure.CellType.STRING, isKeyColumn);
    }

    public void addColumn(String name, JxlColumnStructure.CellType type) {
        this.addColumn(name, type, false);
    }

    public void addColumn(String name, JxlColumnStructure.CellType type, boolean isKeyColumn) {
        if (this.columns == null) {
            this.columns = new ArrayList();
        }
        JxlColumnStructure column = new JxlColumnStructure();
        column.setName(name);
        column.setType(type);
        column.setKeyColumn(isKeyColumn);
        this.columns.add(column);
    }

    public void initSheetWithAutoSize(WritableSheet sheet) throws RowsExceededException, WriteException {
        sheet.setName(this.name);
        for (int i = 0; i < this.columns.size(); ++i) {
            Label label = new Label(i, 0, this.columns.get(i).getName());
            sheet.addCell((WritableCell)label);
            CellView cv = sheet.getColumnView(i);
            cv.setAutosize(true);
            sheet.setColumnView(i, cv);
        }
    }

    public void initSheet(WritableSheet sheet) throws RowsExceededException, WriteException {
        sheet.setName(this.name);
        for (int i = 0; i < this.columns.size(); ++i) {
            Label label = new Label(i, 0, this.columns.get(i).getName());
            sheet.addCell((WritableCell)label);
        }
    }

    private String getOriginalColumnName(String name) {
        for (int i = 0; i < this.columns.size(); ++i) {
            if (!name.equalsIgnoreCase(this.columns.get(i).getName())) continue;
            return this.columns.get(i).getName();
        }
        return null;
    }

    public HashMap<String, Integer> determineColumnsOrder(Sheet jxlSheet) {
        HashMap<String, Integer> columnsOrder = new HashMap<String, Integer>();
        Cell[] cells = jxlSheet.getRow(0);
        if (cells == null) {
            return columnsOrder;
        }
        for (int i = 0; i < cells.length; ++i) {
            String name = cells[i].getContents();
            String structName = this.getOriginalColumnName(name);
            if (structName == null) continue;
            columnsOrder.put(structName, new Integer(i));
        }
        return columnsOrder;
    }
}

