/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.dps.ARValidator;

import com.exlibris.core.infra.common.validation.ValidationResult;
import com.exlibris.digitool.repository.api.xmlbeans.ArExpression;
import com.exlibris.digitool.repository.api.xmlbeans.ArOperation;
import com.exlibris.dps.ARValidator.AbsARValidator;
import java.util.regex.Pattern;

public class IPRangeValidator
extends AbsARValidator {
    private static final String PATTERN = "^(([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.){3}([01]?\\d\\d?|2[0-4]\\d|25[0-5])$";

    @Override
    public ValidationResult validate(ArExpression expr) {
        ValidationResult vr = super.validate(expr);
        if (!vr.isValid()) {
            return vr;
        }
        ArOperation.Enum op = expr.getArOperation();
        String value1 = expr.getVal1();
        String value2 = null;
        boolean ipValid = false;
        boolean isRangeValid = true;
        if (op.toString().equals(ArOperation.CONTAINS.toString())) {
            String[] subValues1;
            for (String ip : subValues1 = value1.split(",")) {
                ipValid = IPRangeValidator.validateIP(ip);
                if (ipValid) continue;
                vr.setValid(false);
                vr.addMessage("Invalid IP: " + ip);
                return vr;
            }
        } else {
            value2 = expr.getVal2();
            boolean bl = ipValid = IPRangeValidator.validateIP(value1) && IPRangeValidator.validateIP(value2);
            if (ipValid) {
                int b;
                value1 = value1.replace(".", "");
                value2 = value2.replace(".", "");
                int a = Integer.parseInt(value1);
                if (a > (b = Integer.parseInt(value2))) {
                    isRangeValid = false;
                }
                if (!isRangeValid) {
                    vr.setValid(false);
                    vr.addMessage("Invalid IP range, first value " + value1 + " is bigger than second value " + value2);
                    return vr;
                }
            }
        }
        vr.setValid(true);
        return vr;
    }

    public static boolean validateIP(String ip) {
        Boolean isMatch = Pattern.matches(PATTERN, ip);
        return isMatch;
    }
}

