/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.dps.sdk.factory;

import com.exlibris.core.infra.svc.api.config.GlobalProperties;
import com.exlibris.core.infra.svc.api.locator.WebServiceLocator;
import com.exlibris.dps.sdk.producer.ProducerWebServices;

public class ProducerWSFactory {
    public static final ProducerWebServices create(String wsdl) {
        boolean isDemo = false;
        try {
            isDemo = new Boolean(GlobalProperties.getInstance().getProperty("rosetta_ws_demo_mode"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (isDemo) {
            return ProducerWSFactory.createDemo(wsdl);
        }
        return ProducerWSFactory.createWS(wsdl);
    }

    public static final ProducerWebServices createDemo(String wsdl) {
        try {
            return (ProducerWebServices)Class.forName("com.exlibris.dps.demo.impl.ProducerServicesImpl").newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
            return ProducerWSFactory.createWS(wsdl);
        }
    }

    public static final ProducerWebServices createWS(String wsdl) {
        return WebServiceLocator.getInstance().lookUp(ProducerWebServices.class, wsdl);
    }
}

