/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.repository.dps.model.events;

import com.exlibris.core.infra.model.DividedDate;
import com.exlibris.repository.dps.model.events.HDeFixityReportEntry;
import com.exlibris.repository.persistence.HDeSet;
import com.exlibris.repository.persistence.HOwneredEntity;
import java.util.Calendar;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.Index;

@NamedQueries(value={@NamedQuery(name="NumberOfObjectsForInstitution", query="select count(*) from HDeEventReport report where owner = :owner"), @NamedQuery(name="isNamePresent", query="select count(id) from HDeEventReport where reportName = :reportName and owner =:owner and id != :id")})
@Entity
@Table(name="HDeEventReport", uniqueConstraints={@UniqueConstraint(columnNames={"owner", "reportName"})})
public class HDeEventReport
extends HOwneredEntity {
    private static final long serialVersionUID = 1L;
    private HDeSet set;
    private Status status;
    private String reportName;
    private String reportDescription;
    private Type reportType;
    private Integer timePeriod;
    private TimePeriodType timePeriodType;
    private Integer storageCopies;
    private Integer fixityEventsPerCopy;
    private String lastRunBy;
    private Calendar lastRunByDate;
    private DividedDate lastRunByDateDummy;
    private List<HDeFixityReportEntry> fixityReportEntries;

    @ManyToOne(targetEntity=HDeSet.class)
    @JoinColumn(name="setId", referencedColumnName="Set_ID_Number")
    @Index(name="SET_ID_IDX")
    public HDeSet getSet() {
        return this.set;
    }

    public void setSet(HDeSet set) {
        this.set = set;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public String getReportName() {
        return this.reportName;
    }

    public void setReportName(String reportName) {
        this.reportName = reportName;
    }

    public String getReportDescription() {
        return this.reportDescription;
    }

    public void setReportDescription(String reportDescription) {
        this.reportDescription = reportDescription;
    }

    public Type getReportType() {
        return this.reportType;
    }

    public void setReportType(Type reportType) {
        this.reportType = reportType;
    }

    public Integer getTimePeriod() {
        return this.timePeriod;
    }

    public void setTimePeriod(Integer timePeriod) {
        this.timePeriod = timePeriod;
    }

    public TimePeriodType getTimePeriodType() {
        return this.timePeriodType;
    }

    public void setTimePeriodType(TimePeriodType timePeriodType) {
        this.timePeriodType = timePeriodType;
    }

    public Integer getStorageCopies() {
        return this.storageCopies;
    }

    public void setStorageCopies(Integer storageCopies) {
        this.storageCopies = storageCopies;
    }

    public Integer getFixityEventsPerCopy() {
        return this.fixityEventsPerCopy;
    }

    public void setFixityEventsPerCopy(Integer fixityEventsPerCopy) {
        this.fixityEventsPerCopy = fixityEventsPerCopy;
    }

    public String getLastRunBy() {
        return this.lastRunBy;
    }

    public void setLastRunBy(String lastRunBy) {
        this.lastRunBy = lastRunBy;
    }

    public Calendar getLastRunByDate() {
        if (this.lastRunByDate == null || this.lastRunByDate.getTimeInMillis() == 0L) {
            return null;
        }
        return this.lastRunByDate;
    }

    public void setLastRunByDate(Calendar lastRunByDate) {
        this.lastRunByDate = lastRunByDate;
        this.lastRunByDateDummy = new DividedDate(this.lastRunByDate);
        this.lastRunByDate = this.lastRunByDateDummy.getCalendar();
    }

    @Transient
    public DividedDate getLastRunByDateDummy() {
        return this.lastRunByDateDummy;
    }

    public void setLastRunByDateDummy(DividedDate lastRunByDateDummy) {
        this.lastRunByDateDummy = lastRunByDateDummy;
    }

    @OneToMany(mappedBy="report", targetEntity=HDeFixityReportEntry.class, cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<HDeFixityReportEntry> getFixityReportEntries() {
        return this.fixityReportEntries;
    }

    public void setFixityReportEntries(List<HDeFixityReportEntry> fixityReportEntries) {
        this.fixityReportEntries = fixityReportEntries;
    }

    public static enum Type {
        MISSING_EVENTS_REPORT;

    }

    public static enum TimePeriodType {
        DAYS,
        WEEKS,
        MONTHS,
        YEARS;

    }

    public static enum Status {
        CREATED,
        RUNNING,
        COMPLETED,
        INACTIVE,
        DELETED;

    }
}

