/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.jpeg2000;

import edu.harvard.hul.ois.jhove.NisoImageMetadata;
import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyArity;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.module.jpeg2000.MainOrTile;
import edu.harvard.hul.ois.jhove.module.jpeg2000.Tile;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public class Codestream
extends MainOrTile {
    private NisoImageMetadata _niso;
    private List _tiles;
    private List _ppmLengthList;
    private Property _labelProperty;
    private Property _compMapProperty;
    private Property _sizProperty;
    private Property _crgProperty;
    private Property _paletteProperty;
    private Property _roiProperty;
    private List tileLengthList;

    public Codestream() {
        this._precSize = null;
        this._niso = new NisoImageMetadata();
    }

    public Property makeProperty() {
        ArrayList<Property> propList = new ArrayList<Property>(10);
        if (this._labelProperty != null) {
            propList.add(this._labelProperty);
        }
        if (this._compMapProperty != null) {
            propList.add(this._compMapProperty);
        }
        if (this._paletteProperty != null) {
            propList.add(this._paletteProperty);
        }
        if (this._roiProperty != null) {
            propList.add(this._roiProperty);
        }
        if (this._sizProperty != null) {
            propList.add(this._sizProperty);
        }
        if (this._codProperty != null) {
            propList.add(this._codProperty);
        }
        if (this._qcdProperty != null) {
            propList.add(this._qcdProperty);
        }
        if (this._pocProperty != null) {
            propList.add(this._pocProperty);
        }
        if (this.tileLengthList != null && !this.tileLengthList.isEmpty()) {
            propList.add(new Property("TileLengths", PropertyType.PROPERTY, PropertyArity.LIST, (Object)this.tileLengthList));
        }
        if (this._packetLengthList != null && !this._packetLengthList.isEmpty()) {
            propList.add(new Property("PacketLengths", PropertyType.LONG, PropertyArity.LIST, (Object)this._packetLengthList));
        }
        if (this._ppmLengthList != null && !this._ppmLengthList.isEmpty()) {
            propList.add(new Property("PackedPacketHeaderLengths", PropertyType.LONG, PropertyArity.LIST, (Object)this._ppmLengthList));
        }
        if (this._crgProperty != null) {
            propList.add(this._crgProperty);
        }
        propList.add(new Property("NisoImageMetadata", PropertyType.NISOIMAGEMETADATA, (Object)this._niso));
        if (this._tiles != null && !this._tiles.isEmpty()) {
            ArrayList<Property> tpList = new ArrayList<Property>(this._tiles.size());
            ListIterator iter = this._tiles.listIterator();
            while (iter.hasNext()) {
                Tile t = (Tile)iter.next();
                tpList.add(t.makeProperty());
            }
            propList.add(new Property("Tiles", PropertyType.PROPERTY, PropertyArity.LIST, tpList));
        }
        if (!this._comments.isEmpty()) {
            propList.add(new Property("Comments", PropertyType.PROPERTY, PropertyArity.LIST, (Object)this._comments));
        }
        if (this._components != null) {
            ArrayList<Property> clist = new ArrayList<Property>(this._components.length);
            for (int i = 0; i < this._components.length; ++i) {
                Property c = this._components[i];
                if (c == null) continue;
                clist.add(c);
            }
            if (!clist.isEmpty()) {
                propList.add(new Property("Components", PropertyType.PROPERTY, PropertyArity.LIST, clist));
            }
        }
        return new Property("Codestream", PropertyType.PROPERTY, PropertyArity.LIST, propList);
    }

    public void setDefaultNiso(NisoImageMetadata dNiso) {
        this._niso.setByteOrder(dNiso.getByteOrder());
        this._niso.setMimeType(dNiso.getMimeType());
        this._niso.setBitsPerSample(dNiso.getBitsPerSample());
        this._niso.setImageLength(dNiso.getImageLength());
        this._niso.setImageWidth(dNiso.getImageWidth());
        this._niso.setSamplesPerPixel(dNiso.getSamplesPerPixel());
        this._niso.setCompressionScheme(dNiso.getCompressionScheme());
        this._niso.setYSamplingFrequency(dNiso.getYSamplingFrequency());
        this._niso.setXSamplingFrequency(dNiso.getXSamplingFrequency());
        this._niso.setSamplingFrequencyUnit(dNiso.getSamplingFrequencyUnit());
    }

    public NisoImageMetadata getNiso() {
        return this._niso;
    }

    public void setTiles(List tiles) {
        this._tiles = tiles;
    }

    public void addTileLength(Property p) {
        if (this.tileLengthList == null) {
            this.tileLengthList = new LinkedList();
        }
        this.tileLengthList.add(p);
    }

    public void addPPMLength(long len) {
        this._ppmLengthList.add(new Long(len));
    }

    protected void setLabelProperty(Property p) {
        this._labelProperty = p;
    }

    protected void setCompMapProperty(Property p) {
        this._compMapProperty = p;
    }

    protected void setPaletteProperty(Property p) {
        this._paletteProperty = p;
    }

    protected void setROIProperty(Property p) {
        this._roiProperty = p;
    }

    protected void setSIZProperty(Property p) {
        this._sizProperty = p;
    }

    protected void setCRGProperty(Property p) {
        this._crgProperty = p;
    }

    @Override
    public void setCompProperty(int idx, Property prop) {
        if (this._components != null && this._components.length > idx) {
            if (this._components[idx] == null) {
                this._components[idx] = new Property("Component", PropertyType.PROPERTY, PropertyArity.LIST, new LinkedList());
            }
            List pList = (List)this._components[idx].getValue();
            pList.add(prop);
        }
    }
}

